// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceGroupUsersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.UserContractInner;
import com.azure.resourcemanager.apimanagement.models.UserContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupUsers;

public final class WorkspaceGroupUsersImpl implements WorkspaceGroupUsers {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceGroupUsersImpl.class);

    private final WorkspaceGroupUsersClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceGroupUsersImpl(WorkspaceGroupUsersClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<UserContract> list(String resourceGroupName, String serviceName, String workspaceId,
        String groupId) {
        PagedIterable<UserContractInner> inner
            = this.serviceClient().list(resourceGroupName, serviceName, workspaceId, groupId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UserContractImpl(inner1, this.manager()));
    }

    public PagedIterable<UserContract> list(String resourceGroupName, String serviceName, String workspaceId,
        String groupId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<UserContractInner> inner = this.serviceClient()
            .list(resourceGroupName, serviceName, workspaceId, groupId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new UserContractImpl(inner1, this.manager()));
    }

    public Response<Boolean> checkEntityExistsWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String groupId, String userId, Context context) {
        return this.serviceClient()
            .checkEntityExistsWithResponse(resourceGroupName, serviceName, workspaceId, groupId, userId, context);
    }

    public boolean checkEntityExists(String resourceGroupName, String serviceName, String workspaceId, String groupId,
        String userId) {
        return this.serviceClient().checkEntityExists(resourceGroupName, serviceName, workspaceId, groupId, userId);
    }

    public Response<UserContract> createWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String groupId, String userId, Context context) {
        Response<UserContractInner> inner = this.serviceClient()
            .createWithResponse(resourceGroupName, serviceName, workspaceId, groupId, userId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new UserContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public UserContract create(String resourceGroupName, String serviceName, String workspaceId, String groupId,
        String userId) {
        UserContractInner inner
            = this.serviceClient().create(resourceGroupName, serviceName, workspaceId, groupId, userId);
        if (inner != null) {
            return new UserContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String groupId, String userId, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, groupId, userId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String groupId,
        String userId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, groupId, userId);
    }

    private WorkspaceGroupUsersClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
