// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceGroupsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.GroupContractInner;
import com.azure.resourcemanager.apimanagement.models.GroupContract;
import com.azure.resourcemanager.apimanagement.models.GroupCreateParameters;
import com.azure.resourcemanager.apimanagement.models.GroupUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroups;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceGroupsUpdateResponse;

public final class WorkspaceGroupsImpl implements WorkspaceGroups {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceGroupsImpl.class);

    private final WorkspaceGroupsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceGroupsImpl(WorkspaceGroupsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<GroupContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId) {
        PagedIterable<GroupContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GroupContractImpl(inner1, this.manager()));
    }

    public PagedIterable<GroupContract> listByService(String resourceGroupName, String serviceName, String workspaceId,
        String filter, Integer top, Integer skip, Context context) {
        PagedIterable<GroupContractInner> inner = this.serviceClient()
            .listByService(resourceGroupName, serviceName, workspaceId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new GroupContractImpl(inner1, this.manager()));
    }

    public WorkspaceGroupsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String groupId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, groupId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String groupId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, groupId);
    }

    public Response<GroupContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String groupId, Context context) {
        WorkspaceGroupsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, groupId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GroupContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GroupContract get(String resourceGroupName, String serviceName, String workspaceId, String groupId) {
        GroupContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, groupId);
        if (inner != null) {
            return new GroupContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<GroupContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String groupId, GroupCreateParameters parameters, String ifMatch, Context context) {
        WorkspaceGroupsCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, groupId, parameters, ifMatch,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GroupContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GroupContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String groupId, GroupCreateParameters parameters) {
        GroupContractInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, groupId, parameters);
        if (inner != null) {
            return new GroupContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<GroupContract> updateWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String groupId, String ifMatch, GroupUpdateParameters parameters, Context context) {
        WorkspaceGroupsUpdateResponse inner = this.serviceClient()
            .updateWithResponse(resourceGroupName, serviceName, workspaceId, groupId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new GroupContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public GroupContract update(String resourceGroupName, String serviceName, String workspaceId, String groupId,
        String ifMatch, GroupUpdateParameters parameters) {
        GroupContractInner inner
            = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, groupId, ifMatch, parameters);
        if (inner != null) {
            return new GroupContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String groupId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, groupId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String groupId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, groupId, ifMatch);
    }

    private WorkspaceGroupsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
