// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceNamedValuesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueContractInner;
import com.azure.resourcemanager.apimanagement.fluent.models.NamedValueSecretContractInner;
import com.azure.resourcemanager.apimanagement.models.KeyVaultRefreshState;
import com.azure.resourcemanager.apimanagement.models.NamedValueContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueCreateContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueSecretContract;
import com.azure.resourcemanager.apimanagement.models.NamedValueUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNamedValues;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNamedValuesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNamedValuesGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNamedValuesListValueResponse;

public final class WorkspaceNamedValuesImpl implements WorkspaceNamedValues {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceNamedValuesImpl.class);

    private final WorkspaceNamedValuesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceNamedValuesImpl(WorkspaceNamedValuesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<NamedValueContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId) {
        PagedIterable<NamedValueContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NamedValueContractImpl(inner1, this.manager()));
    }

    public PagedIterable<NamedValueContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId, String filter, Integer top, Integer skip, KeyVaultRefreshState isKeyVaultRefreshFailed,
        Context context) {
        PagedIterable<NamedValueContractInner> inner = this.serviceClient()
            .listByService(resourceGroupName, serviceName, workspaceId, filter, top, skip, isKeyVaultRefreshFailed,
                context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NamedValueContractImpl(inner1, this.manager()));
    }

    public WorkspaceNamedValuesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName,
        String serviceName, String workspaceId, String namedValueId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, namedValueId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String namedValueId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, namedValueId);
    }

    public Response<NamedValueContract> getWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String namedValueId, Context context) {
        WorkspaceNamedValuesGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, namedValueId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new NamedValueContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public NamedValueContract get(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId) {
        NamedValueContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, namedValueId);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId, NamedValueCreateContract parameters) {
        NamedValueContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, namedValueId, parameters);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId, NamedValueCreateContract parameters, String ifMatch, Context context) {
        NamedValueContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, namedValueId, parameters, ifMatch, context);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract update(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId, String ifMatch, NamedValueUpdateParameters parameters) {
        NamedValueContractInner inner = this.serviceClient()
            .update(resourceGroupName, serviceName, workspaceId, namedValueId, ifMatch, parameters);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract update(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId, String ifMatch, NamedValueUpdateParameters parameters, Context context) {
        NamedValueContractInner inner = this.serviceClient()
            .update(resourceGroupName, serviceName, workspaceId, namedValueId, ifMatch, parameters, context);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId, String ifMatch, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, namedValueId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String namedValueId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, namedValueId, ifMatch);
    }

    public Response<NamedValueSecretContract> listValueWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String namedValueId, Context context) {
        WorkspaceNamedValuesListValueResponse inner = this.serviceClient()
            .listValueWithResponse(resourceGroupName, serviceName, workspaceId, namedValueId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new NamedValueSecretContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public NamedValueSecretContract listValue(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId) {
        NamedValueSecretContractInner inner
            = this.serviceClient().listValue(resourceGroupName, serviceName, workspaceId, namedValueId);
        if (inner != null) {
            return new NamedValueSecretContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract refreshSecret(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId) {
        NamedValueContractInner inner
            = this.serviceClient().refreshSecret(resourceGroupName, serviceName, workspaceId, namedValueId);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public NamedValueContract refreshSecret(String resourceGroupName, String serviceName, String workspaceId,
        String namedValueId, Context context) {
        NamedValueContractInner inner
            = this.serviceClient().refreshSecret(resourceGroupName, serviceName, workspaceId, namedValueId, context);
        if (inner != null) {
            return new NamedValueContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private WorkspaceNamedValuesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
