// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceNotificationRecipientUsersClient;
import com.azure.resourcemanager.apimanagement.fluent.models.RecipientUserCollectionInner;
import com.azure.resourcemanager.apimanagement.fluent.models.RecipientUserContractInner;
import com.azure.resourcemanager.apimanagement.models.NotificationName;
import com.azure.resourcemanager.apimanagement.models.RecipientUserCollection;
import com.azure.resourcemanager.apimanagement.models.RecipientUserContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNotificationRecipientUsers;

public final class WorkspaceNotificationRecipientUsersImpl implements WorkspaceNotificationRecipientUsers {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceNotificationRecipientUsersImpl.class);

    private final WorkspaceNotificationRecipientUsersClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceNotificationRecipientUsersImpl(WorkspaceNotificationRecipientUsersClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public Response<RecipientUserCollection> listByNotificationWithResponse(String resourceGroupName,
        String serviceName, String workspaceId, NotificationName notificationName, Context context) {
        Response<RecipientUserCollectionInner> inner = this.serviceClient()
            .listByNotificationWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new RecipientUserCollectionImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public RecipientUserCollection listByNotification(String resourceGroupName, String serviceName, String workspaceId,
        NotificationName notificationName) {
        RecipientUserCollectionInner inner
            = this.serviceClient().listByNotification(resourceGroupName, serviceName, workspaceId, notificationName);
        if (inner != null) {
            return new RecipientUserCollectionImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Boolean> checkEntityExistsWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, NotificationName notificationName, String userId, Context context) {
        return this.serviceClient()
            .checkEntityExistsWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, userId,
                context);
    }

    public boolean checkEntityExists(String resourceGroupName, String serviceName, String workspaceId,
        NotificationName notificationName, String userId) {
        return this.serviceClient()
            .checkEntityExists(resourceGroupName, serviceName, workspaceId, notificationName, userId);
    }

    public Response<RecipientUserContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, NotificationName notificationName, String userId, Context context) {
        Response<RecipientUserContractInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, userId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new RecipientUserContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public RecipientUserContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        NotificationName notificationName, String userId) {
        RecipientUserContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, notificationName, userId);
        if (inner != null) {
            return new RecipientUserContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        NotificationName notificationName, String userId, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, userId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId,
        NotificationName notificationName, String userId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, notificationName, userId);
    }

    private WorkspaceNotificationRecipientUsersClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
