// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceNotificationsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.NotificationContractInner;
import com.azure.resourcemanager.apimanagement.models.NotificationContract;
import com.azure.resourcemanager.apimanagement.models.NotificationName;
import com.azure.resourcemanager.apimanagement.models.WorkspaceNotifications;

public final class WorkspaceNotificationsImpl implements WorkspaceNotifications {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceNotificationsImpl.class);

    private final WorkspaceNotificationsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceNotificationsImpl(WorkspaceNotificationsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<NotificationContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId) {
        PagedIterable<NotificationContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NotificationContractImpl(inner1, this.manager()));
    }

    public PagedIterable<NotificationContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId, Integer top, Integer skip, Context context) {
        PagedIterable<NotificationContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new NotificationContractImpl(inner1, this.manager()));
    }

    public Response<NotificationContract> getWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, NotificationName notificationName, Context context) {
        Response<NotificationContractInner> inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new NotificationContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public NotificationContract get(String resourceGroupName, String serviceName, String workspaceId,
        NotificationName notificationName) {
        NotificationContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, notificationName);
        if (inner != null) {
            return new NotificationContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<NotificationContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, NotificationName notificationName, String ifMatch, Context context) {
        Response<NotificationContractInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, notificationName, ifMatch,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new NotificationContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public NotificationContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        NotificationName notificationName) {
        NotificationContractInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, notificationName);
        if (inner != null) {
            return new NotificationContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    private WorkspaceNotificationsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
