// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceProductApiLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductApiLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductApiLinkContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductApiLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductApiLinksGetResponse;

public final class WorkspaceProductApiLinksImpl implements WorkspaceProductApiLinks {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceProductApiLinksImpl.class);

    private final WorkspaceProductApiLinksClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceProductApiLinksImpl(WorkspaceProductApiLinksClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ProductApiLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String workspaceId, String productId) {
        PagedIterable<ProductApiLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductApiLinkContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ProductApiLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductApiLinkContractInner> inner = this.serviceClient()
            .listByProduct(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductApiLinkContractImpl(inner1, this.manager()));
    }

    public Response<ProductApiLinkContract> getWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String apiLinkId, Context context) {
        WorkspaceProductApiLinksGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductApiLinkContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductApiLinkContract get(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String apiLinkId) {
        ProductApiLinkContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, productId, apiLinkId);
        if (inner != null) {
            return new ProductApiLinkContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ProductApiLinkContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String apiLinkId, ProductApiLinkContractInner parameters,
        Context context) {
        Response<ProductApiLinkContractInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, parameters,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductApiLinkContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductApiLinkContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String apiLinkId, ProductApiLinkContractInner parameters) {
        ProductApiLinkContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, parameters);
        if (inner != null) {
            return new ProductApiLinkContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String apiLinkId, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, productId, apiLinkId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String productId,
        String apiLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, productId, apiLinkId);
    }

    private WorkspaceProductApiLinksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
