// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceProductGroupLinksClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductGroupLinkContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductGroupLinkContract;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductGroupLinks;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductGroupLinksGetResponse;

public final class WorkspaceProductGroupLinksImpl implements WorkspaceProductGroupLinks {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceProductGroupLinksImpl.class);

    private final WorkspaceProductGroupLinksClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceProductGroupLinksImpl(WorkspaceProductGroupLinksClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String workspaceId, String productId) {
        PagedIterable<ProductGroupLinkContractInner> inner
            = this.serviceClient().listByProduct(resourceGroupName, serviceName, workspaceId, productId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductGroupLinkContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ProductGroupLinkContract> listByProduct(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String filter, Integer top, Integer skip, Context context) {
        PagedIterable<ProductGroupLinkContractInner> inner = this.serviceClient()
            .listByProduct(resourceGroupName, serviceName, workspaceId, productId, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductGroupLinkContractImpl(inner1, this.manager()));
    }

    public Response<ProductGroupLinkContract> getWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String groupLinkId, Context context) {
        WorkspaceProductGroupLinksGetResponse inner = this.serviceClient()
            .getWithResponse(resourceGroupName, serviceName, workspaceId, productId, groupLinkId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductGroupLinkContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductGroupLinkContract get(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String groupLinkId) {
        ProductGroupLinkContractInner inner
            = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, productId, groupLinkId);
        if (inner != null) {
            return new ProductGroupLinkContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ProductGroupLinkContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String groupLinkId, ProductGroupLinkContractInner parameters,
        Context context) {
        Response<ProductGroupLinkContractInner> inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, productId, groupLinkId, parameters,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductGroupLinkContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductGroupLinkContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String groupLinkId, ProductGroupLinkContractInner parameters) {
        ProductGroupLinkContractInner inner = this.serviceClient()
            .createOrUpdate(resourceGroupName, serviceName, workspaceId, productId, groupLinkId, parameters);
        if (inner != null) {
            return new ProductGroupLinkContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String groupLinkId, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, productId, groupLinkId, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String productId,
        String groupLinkId) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, productId, groupLinkId);
    }

    private WorkspaceProductGroupLinksClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
