// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspaceProductsClient;
import com.azure.resourcemanager.apimanagement.fluent.models.ProductContractInner;
import com.azure.resourcemanager.apimanagement.models.ProductContract;
import com.azure.resourcemanager.apimanagement.models.ProductUpdateParameters;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProducts;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductsCreateOrUpdateResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductsGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductsGetResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspaceProductsUpdateResponse;

public final class WorkspaceProductsImpl implements WorkspaceProducts {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspaceProductsImpl.class);

    private final WorkspaceProductsClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspaceProductsImpl(WorkspaceProductsClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<ProductContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId) {
        PagedIterable<ProductContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, workspaceId);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductContractImpl(inner1, this.manager()));
    }

    public PagedIterable<ProductContract> listByService(String resourceGroupName, String serviceName,
        String workspaceId, String filter, Integer top, Integer skip, Boolean expandGroups, String tags,
        Context context) {
        PagedIterable<ProductContractInner> inner = this.serviceClient()
            .listByService(resourceGroupName, serviceName, workspaceId, filter, top, skip, expandGroups, tags, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new ProductContractImpl(inner1, this.manager()));
    }

    public WorkspaceProductsGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String productId, Context context) {
        return this.serviceClient()
            .getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, productId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId, String productId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId, productId);
    }

    public Response<ProductContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String productId, Context context) {
        WorkspaceProductsGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, productId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductContract get(String resourceGroupName, String serviceName, String workspaceId, String productId) {
        ProductContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId, productId);
        if (inner != null) {
            return new ProductContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ProductContract> createOrUpdateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String productId, ProductContractInner parameters, String ifMatch, Context context) {
        WorkspaceProductsCreateOrUpdateResponse inner = this.serviceClient()
            .createOrUpdateWithResponse(resourceGroupName, serviceName, workspaceId, productId, parameters, ifMatch,
                context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductContract createOrUpdate(String resourceGroupName, String serviceName, String workspaceId,
        String productId, ProductContractInner parameters) {
        ProductContractInner inner
            = this.serviceClient().createOrUpdate(resourceGroupName, serviceName, workspaceId, productId, parameters);
        if (inner != null) {
            return new ProductContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<ProductContract> updateWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, String productId, String ifMatch, ProductUpdateParameters parameters, Context context) {
        WorkspaceProductsUpdateResponse inner = this.serviceClient()
            .updateWithResponse(resourceGroupName, serviceName, workspaceId, productId, ifMatch, parameters, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new ProductContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public ProductContract update(String resourceGroupName, String serviceName, String workspaceId, String productId,
        String ifMatch, ProductUpdateParameters parameters) {
        ProductContractInner inner
            = this.serviceClient().update(resourceGroupName, serviceName, workspaceId, productId, ifMatch, parameters);
        if (inner != null) {
            return new ProductContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String productId, String ifMatch, Boolean deleteSubscriptions, Context context) {
        return this.serviceClient()
            .deleteWithResponse(resourceGroupName, serviceName, workspaceId, productId, ifMatch, deleteSubscriptions,
                context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String productId,
        String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, productId, ifMatch);
    }

    private WorkspaceProductsClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }
}
