// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.implementation;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.resourcemanager.apimanagement.fluent.WorkspacesClient;
import com.azure.resourcemanager.apimanagement.fluent.models.WorkspaceContractInner;
import com.azure.resourcemanager.apimanagement.models.WorkspaceContract;
import com.azure.resourcemanager.apimanagement.models.Workspaces;
import com.azure.resourcemanager.apimanagement.models.WorkspacesGetEntityTagResponse;
import com.azure.resourcemanager.apimanagement.models.WorkspacesGetResponse;

public final class WorkspacesImpl implements Workspaces {
    private static final ClientLogger LOGGER = new ClientLogger(WorkspacesImpl.class);

    private final WorkspacesClient innerClient;

    private final com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager;

    public WorkspacesImpl(WorkspacesClient innerClient,
        com.azure.resourcemanager.apimanagement.ApiManagementManager serviceManager) {
        this.innerClient = innerClient;
        this.serviceManager = serviceManager;
    }

    public PagedIterable<WorkspaceContract> listByService(String resourceGroupName, String serviceName) {
        PagedIterable<WorkspaceContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceContractImpl(inner1, this.manager()));
    }

    public PagedIterable<WorkspaceContract> listByService(String resourceGroupName, String serviceName, String filter,
        Integer top, Integer skip, Context context) {
        PagedIterable<WorkspaceContractInner> inner
            = this.serviceClient().listByService(resourceGroupName, serviceName, filter, top, skip, context);
        return ResourceManagerUtils.mapPage(inner, inner1 -> new WorkspaceContractImpl(inner1, this.manager()));
    }

    public WorkspacesGetEntityTagResponse getEntityTagWithResponse(String resourceGroupName, String serviceName,
        String workspaceId, Context context) {
        return this.serviceClient().getEntityTagWithResponse(resourceGroupName, serviceName, workspaceId, context);
    }

    public void getEntityTag(String resourceGroupName, String serviceName, String workspaceId) {
        this.serviceClient().getEntityTag(resourceGroupName, serviceName, workspaceId);
    }

    public Response<WorkspaceContract> getWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        Context context) {
        WorkspacesGetResponse inner
            = this.serviceClient().getWithResponse(resourceGroupName, serviceName, workspaceId, context);
        if (inner != null) {
            return new SimpleResponse<>(inner.getRequest(), inner.getStatusCode(), inner.getHeaders(),
                new WorkspaceContractImpl(inner.getValue(), this.manager()));
        } else {
            return null;
        }
    }

    public WorkspaceContract get(String resourceGroupName, String serviceName, String workspaceId) {
        WorkspaceContractInner inner = this.serviceClient().get(resourceGroupName, serviceName, workspaceId);
        if (inner != null) {
            return new WorkspaceContractImpl(inner, this.manager());
        } else {
            return null;
        }
    }

    public Response<Void> deleteWithResponse(String resourceGroupName, String serviceName, String workspaceId,
        String ifMatch, Context context) {
        return this.serviceClient().deleteWithResponse(resourceGroupName, serviceName, workspaceId, ifMatch, context);
    }

    public void delete(String resourceGroupName, String serviceName, String workspaceId, String ifMatch) {
        this.serviceClient().delete(resourceGroupName, serviceName, workspaceId, ifMatch);
    }

    public WorkspaceContract getById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String workspaceId = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, workspaceId, Context.NONE).getValue();
    }

    public Response<WorkspaceContract> getByIdWithResponse(String id, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String workspaceId = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        return this.getWithResponse(resourceGroupName, serviceName, workspaceId, context);
    }

    public void deleteById(String id) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String workspaceId = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        String localIfMatch = null;
        this.deleteWithResponse(resourceGroupName, serviceName, workspaceId, localIfMatch, Context.NONE);
    }

    public Response<Void> deleteByIdWithResponse(String id, String ifMatch, Context context) {
        String resourceGroupName = ResourceManagerUtils.getValueFromIdByName(id, "resourceGroups");
        if (resourceGroupName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'resourceGroups'.", id)));
        }
        String serviceName = ResourceManagerUtils.getValueFromIdByName(id, "service");
        if (serviceName == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'service'.", id)));
        }
        String workspaceId = ResourceManagerUtils.getValueFromIdByName(id, "workspaces");
        if (workspaceId == null) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(
                String.format("The resource ID '%s' is not valid. Missing path segment 'workspaces'.", id)));
        }
        return this.deleteWithResponse(resourceGroupName, serviceName, workspaceId, ifMatch, context);
    }

    private WorkspacesClient serviceClient() {
        return this.innerClient;
    }

    private com.azure.resourcemanager.apimanagement.ApiManagementManager manager() {
        return this.serviceManager;
    }

    public WorkspaceContractImpl define(String name) {
        return new WorkspaceContractImpl(name, this.manager());
    }
}
