// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.AccessInformationUpdateParameterProperties;
import java.io.IOException;

/**
 * Tenant access information update parameters.
 */
@Fluent
public final class AccessInformationUpdateParameters implements JsonSerializable<AccessInformationUpdateParameters> {
    /*
     * Tenant access information update parameter properties.
     */
    private AccessInformationUpdateParameterProperties innerProperties;

    /**
     * Creates an instance of AccessInformationUpdateParameters class.
     */
    public AccessInformationUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Tenant access information update parameter properties.
     * 
     * @return the innerProperties value.
     */
    private AccessInformationUpdateParameterProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the enabled property: Determines whether direct access is enabled.
     * 
     * @return the enabled value.
     */
    public Boolean enabled() {
        return this.innerProperties() == null ? null : this.innerProperties().enabled();
    }

    /**
     * Set the enabled property: Determines whether direct access is enabled.
     * 
     * @param enabled the enabled value to set.
     * @return the AccessInformationUpdateParameters object itself.
     */
    public AccessInformationUpdateParameters withEnabled(Boolean enabled) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AccessInformationUpdateParameterProperties();
        }
        this.innerProperties().withEnabled(enabled);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AccessInformationUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AccessInformationUpdateParameters if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AccessInformationUpdateParameters.
     */
    public static AccessInformationUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AccessInformationUpdateParameters deserializedAccessInformationUpdateParameters
                = new AccessInformationUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("properties".equals(fieldName)) {
                    deserializedAccessInformationUpdateParameters.innerProperties
                        = AccessInformationUpdateParameterProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAccessInformationUpdateParameters;
        });
    }
}
