// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * API contact information.
 */
@Fluent
public final class ApiContactInformation implements JsonSerializable<ApiContactInformation> {
    /*
     * The identifying name of the contact person/organization
     */
    private String name;

    /*
     * The URL pointing to the contact information. MUST be in the format of a URL
     */
    private String url;

    /*
     * The email address of the contact person/organization. MUST be in the format of an email address
     */
    private String email;

    /**
     * Creates an instance of ApiContactInformation class.
     */
    public ApiContactInformation() {
    }

    /**
     * Get the name property: The identifying name of the contact person/organization.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The identifying name of the contact person/organization.
     * 
     * @param name the name value to set.
     * @return the ApiContactInformation object itself.
     */
    public ApiContactInformation withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the url property: The URL pointing to the contact information. MUST be in the format of a URL.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: The URL pointing to the contact information. MUST be in the format of a URL.
     * 
     * @param url the url value to set.
     * @return the ApiContactInformation object itself.
     */
    public ApiContactInformation withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Get the email property: The email address of the contact person/organization. MUST be in the format of an email
     * address.
     * 
     * @return the email value.
     */
    public String email() {
        return this.email;
    }

    /**
     * Set the email property: The email address of the contact person/organization. MUST be in the format of an email
     * address.
     * 
     * @param email the email value to set.
     * @return the ApiContactInformation object itself.
     */
    public ApiContactInformation withEmail(String email) {
        this.email = email;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("url", this.url);
        jsonWriter.writeStringField("email", this.email);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiContactInformation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiContactInformation if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiContactInformation.
     */
    public static ApiContactInformation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiContactInformation deserializedApiContactInformation = new ApiContactInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApiContactInformation.name = reader.getString();
                } else if ("url".equals(fieldName)) {
                    deserializedApiContactInformation.url = reader.getString();
                } else if ("email".equals(fieldName)) {
                    deserializedApiContactInformation.email = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiContactInformation;
        });
    }
}
