// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Criteria to limit import of WSDL to a subset of the document.
 */
@Fluent
public final class ApiCreateOrUpdatePropertiesWsdlSelector
    implements JsonSerializable<ApiCreateOrUpdatePropertiesWsdlSelector> {
    /*
     * Name of service to import from WSDL
     */
    private String wsdlServiceName;

    /*
     * Name of endpoint(port) to import from WSDL
     */
    private String wsdlEndpointName;

    /**
     * Creates an instance of ApiCreateOrUpdatePropertiesWsdlSelector class.
     */
    public ApiCreateOrUpdatePropertiesWsdlSelector() {
    }

    /**
     * Get the wsdlServiceName property: Name of service to import from WSDL.
     * 
     * @return the wsdlServiceName value.
     */
    public String wsdlServiceName() {
        return this.wsdlServiceName;
    }

    /**
     * Set the wsdlServiceName property: Name of service to import from WSDL.
     * 
     * @param wsdlServiceName the wsdlServiceName value to set.
     * @return the ApiCreateOrUpdatePropertiesWsdlSelector object itself.
     */
    public ApiCreateOrUpdatePropertiesWsdlSelector withWsdlServiceName(String wsdlServiceName) {
        this.wsdlServiceName = wsdlServiceName;
        return this;
    }

    /**
     * Get the wsdlEndpointName property: Name of endpoint(port) to import from WSDL.
     * 
     * @return the wsdlEndpointName value.
     */
    public String wsdlEndpointName() {
        return this.wsdlEndpointName;
    }

    /**
     * Set the wsdlEndpointName property: Name of endpoint(port) to import from WSDL.
     * 
     * @param wsdlEndpointName the wsdlEndpointName value to set.
     * @return the ApiCreateOrUpdatePropertiesWsdlSelector object itself.
     */
    public ApiCreateOrUpdatePropertiesWsdlSelector withWsdlEndpointName(String wsdlEndpointName) {
        this.wsdlEndpointName = wsdlEndpointName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("wsdlServiceName", this.wsdlServiceName);
        jsonWriter.writeStringField("wsdlEndpointName", this.wsdlEndpointName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiCreateOrUpdatePropertiesWsdlSelector from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiCreateOrUpdatePropertiesWsdlSelector if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiCreateOrUpdatePropertiesWsdlSelector.
     */
    public static ApiCreateOrUpdatePropertiesWsdlSelector fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiCreateOrUpdatePropertiesWsdlSelector deserializedApiCreateOrUpdatePropertiesWsdlSelector
                = new ApiCreateOrUpdatePropertiesWsdlSelector();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("wsdlServiceName".equals(fieldName)) {
                    deserializedApiCreateOrUpdatePropertiesWsdlSelector.wsdlServiceName = reader.getString();
                } else if ("wsdlEndpointName".equals(fieldName)) {
                    deserializedApiCreateOrUpdatePropertiesWsdlSelector.wsdlEndpointName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiCreateOrUpdatePropertiesWsdlSelector;
        });
    }
}
