// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * The object defining the schema of the exported API Detail.
 */
@Fluent
public final class ApiExportResultValue implements JsonSerializable<ApiExportResultValue> {
    /*
     * Link to the Storage Blob containing the result of the export operation. The Blob Uri is only valid for 5 minutes.
     */
    private String link;

    /**
     * Creates an instance of ApiExportResultValue class.
     */
    public ApiExportResultValue() {
    }

    /**
     * Get the link property: Link to the Storage Blob containing the result of the export operation. The Blob Uri is
     * only valid for 5 minutes.
     * 
     * @return the link value.
     */
    public String link() {
        return this.link;
    }

    /**
     * Set the link property: Link to the Storage Blob containing the result of the export operation. The Blob Uri is
     * only valid for 5 minutes.
     * 
     * @param link the link value to set.
     * @return the ApiExportResultValue object itself.
     */
    public ApiExportResultValue withLink(String link) {
        this.link = link;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("link", this.link);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiExportResultValue from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiExportResultValue if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiExportResultValue.
     */
    public static ApiExportResultValue fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiExportResultValue deserializedApiExportResultValue = new ApiExportResultValue();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("link".equals(fieldName)) {
                    deserializedApiExportResultValue.link = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiExportResultValue;
        });
    }
}
