// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of ApiGatewayConfigConnections.
 */
public interface ApiGatewayConfigConnections {
    /**
     * List all API Management gateway config connections within a gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management gateway operation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<ApiManagementGatewayConfigConnectionResource> listByGateway(String resourceGroupName,
        String gatewayName);

    /**
     * List all API Management gateway config connections within a gateway.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management gateway operation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<ApiManagementGatewayConfigConnectionResource> listByGateway(String resourceGroupName,
        String gatewayName, Context context);

    /**
     * Gets an API Management gateway config connection resource description.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management gateway config connection resource description along with {@link Response}.
     */
    Response<ApiManagementGatewayConfigConnectionResource> getWithResponse(String resourceGroupName, String gatewayName,
        String configConnectionName, Context context);

    /**
     * Gets an API Management gateway config connection resource description.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management gateway config connection resource description.
     */
    ApiManagementGatewayConfigConnectionResource get(String resourceGroupName, String gatewayName,
        String configConnectionName);

    /**
     * Deletes an existing API Management gateway config connection.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String gatewayName, String configConnectionName, String ifMatch);

    /**
     * Deletes an existing API Management gateway config connection.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param gatewayName The name of the API Management gateway.
     * @param configConnectionName The name of the API Management gateway config connection.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void delete(String resourceGroupName, String gatewayName, String configConnectionName, String ifMatch,
        Context context);

    /**
     * Gets an API Management gateway config connection resource description.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management gateway config connection resource description along with {@link Response}.
     */
    ApiManagementGatewayConfigConnectionResource getById(String id);

    /**
     * Gets an API Management gateway config connection resource description.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management gateway config connection resource description along with {@link Response}.
     */
    Response<ApiManagementGatewayConfigConnectionResource> getByIdWithResponse(String id, Context context);

    /**
     * Deletes an existing API Management gateway config connection.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteById(String id);

    /**
     * Deletes an existing API Management gateway config connection.
     * 
     * @param id the resource ID.
     * @param ifMatch ETag of the Entity. ETag should match the current entity state from the header response of the GET
     * request or it should be * for unconditional update.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void deleteByIdWithResponse(String id, String ifMatch, Context context);

    /**
     * Begins definition for a new ApiManagementGatewayConfigConnectionResource resource.
     * 
     * @param name resource name.
     * @return the first stage of the new ApiManagementGatewayConfigConnectionResource definition.
     */
    ApiManagementGatewayConfigConnectionResource.DefinitionStages.Blank define(String name);
}
