// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Name of the Sku.
 */
public final class ApiGatewaySkuType extends ExpandableStringEnum<ApiGatewaySkuType> {
    /**
     * Static value Standard for ApiGatewaySkuType.
     */
    public static final ApiGatewaySkuType STANDARD = fromString("Standard");

    /**
     * Static value WorkspaceGatewayStandard for ApiGatewaySkuType.
     */
    public static final ApiGatewaySkuType WORKSPACE_GATEWAY_STANDARD = fromString("WorkspaceGatewayStandard");

    /**
     * Static value WorkspaceGatewayPremium for ApiGatewaySkuType.
     */
    public static final ApiGatewaySkuType WORKSPACE_GATEWAY_PREMIUM = fromString("WorkspaceGatewayPremium");

    /**
     * Creates a new instance of ApiGatewaySkuType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ApiGatewaySkuType() {
    }

    /**
     * Creates or finds a ApiGatewaySkuType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ApiGatewaySkuType.
     */
    public static ApiGatewaySkuType fromString(String name) {
        return fromString(name, ApiGatewaySkuType.class);
    }

    /**
     * Gets known ApiGatewaySkuType values.
     * 
     * @return known ApiGatewaySkuType values.
     */
    public static Collection<ApiGatewaySkuType> values() {
        return values(ApiGatewaySkuType.class);
    }
}
