// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * API license information.
 */
@Fluent
public final class ApiLicenseInformation implements JsonSerializable<ApiLicenseInformation> {
    /*
     * The license name used for the API
     */
    private String name;

    /*
     * A URL to the license used for the API. MUST be in the format of a URL
     */
    private String url;

    /**
     * Creates an instance of ApiLicenseInformation class.
     */
    public ApiLicenseInformation() {
    }

    /**
     * Get the name property: The license name used for the API.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The license name used for the API.
     * 
     * @param name the name value to set.
     * @return the ApiLicenseInformation object itself.
     */
    public ApiLicenseInformation withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the url property: A URL to the license used for the API. MUST be in the format of a URL.
     * 
     * @return the url value.
     */
    public String url() {
        return this.url;
    }

    /**
     * Set the url property: A URL to the license used for the API. MUST be in the format of a URL.
     * 
     * @param url the url value to set.
     * @return the ApiLicenseInformation object itself.
     */
    public ApiLicenseInformation withUrl(String url) {
        this.url = url;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("url", this.url);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiLicenseInformation from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiLicenseInformation if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiLicenseInformation.
     */
    public static ApiLicenseInformation fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiLicenseInformation deserializedApiLicenseInformation = new ApiLicenseInformation();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApiLicenseInformation.name = reader.getString();
                } else if ("url".equals(fieldName)) {
                    deserializedApiLicenseInformation.url = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiLicenseInformation;
        });
    }
}
