// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;

/**
 * Base Properties of an API Management gateway resource description.
 */
@Fluent
public class ApiManagementGatewayBaseProperties implements JsonSerializable<ApiManagementGatewayBaseProperties> {
    /*
     * The current provisioning state of the API Management gateway which can be one of the following:
     * Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     */
    private String provisioningState;

    /*
     * The provisioning state of the API Management gateway, which is targeted by the long running operation started on
     * the gateway.
     */
    private String targetProvisioningState;

    /*
     * Creation UTC date of the API Management gateway.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ`
     * as specified by the ISO 8601 standard.
     */
    private OffsetDateTime createdAtUtc;

    /*
     * Information regarding how the gateway should be exposed.
     */
    private FrontendConfiguration frontend;

    /*
     * Information regarding how the gateway should integrate with backend systems.
     */
    private BackendConfiguration backend;

    /*
     * Information regarding the Configuration API of the API Management gateway. This is only applicable for API
     * gateway with Standard SKU.
     */
    private GatewayConfigurationApi configurationApi;

    /*
     * The type of VPN in which API Management gateway needs to be configured in.
     */
    private VirtualNetworkType virtualNetworkType;

    /**
     * Creates an instance of ApiManagementGatewayBaseProperties class.
     */
    public ApiManagementGatewayBaseProperties() {
    }

    /**
     * Get the provisioningState property: The current provisioning state of the API Management gateway which can be one
     * of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: The current provisioning state of the API Management gateway which can be one
     * of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the ApiManagementGatewayBaseProperties object itself.
     */
    ApiManagementGatewayBaseProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the targetProvisioningState property: The provisioning state of the API Management gateway, which is targeted
     * by the long running operation started on the gateway.
     * 
     * @return the targetProvisioningState value.
     */
    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    /**
     * Set the targetProvisioningState property: The provisioning state of the API Management gateway, which is targeted
     * by the long running operation started on the gateway.
     * 
     * @param targetProvisioningState the targetProvisioningState value to set.
     * @return the ApiManagementGatewayBaseProperties object itself.
     */
    ApiManagementGatewayBaseProperties withTargetProvisioningState(String targetProvisioningState) {
        this.targetProvisioningState = targetProvisioningState;
        return this;
    }

    /**
     * Get the createdAtUtc property: Creation UTC date of the API Management gateway.The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the createdAtUtc value.
     */
    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    /**
     * Set the createdAtUtc property: Creation UTC date of the API Management gateway.The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param createdAtUtc the createdAtUtc value to set.
     * @return the ApiManagementGatewayBaseProperties object itself.
     */
    ApiManagementGatewayBaseProperties withCreatedAtUtc(OffsetDateTime createdAtUtc) {
        this.createdAtUtc = createdAtUtc;
        return this;
    }

    /**
     * Get the frontend property: Information regarding how the gateway should be exposed.
     * 
     * @return the frontend value.
     */
    public FrontendConfiguration frontend() {
        return this.frontend;
    }

    /**
     * Set the frontend property: Information regarding how the gateway should be exposed.
     * 
     * @param frontend the frontend value to set.
     * @return the ApiManagementGatewayBaseProperties object itself.
     */
    public ApiManagementGatewayBaseProperties withFrontend(FrontendConfiguration frontend) {
        this.frontend = frontend;
        return this;
    }

    /**
     * Get the backend property: Information regarding how the gateway should integrate with backend systems.
     * 
     * @return the backend value.
     */
    public BackendConfiguration backend() {
        return this.backend;
    }

    /**
     * Set the backend property: Information regarding how the gateway should integrate with backend systems.
     * 
     * @param backend the backend value to set.
     * @return the ApiManagementGatewayBaseProperties object itself.
     */
    public ApiManagementGatewayBaseProperties withBackend(BackendConfiguration backend) {
        this.backend = backend;
        return this;
    }

    /**
     * Get the configurationApi property: Information regarding the Configuration API of the API Management gateway.
     * This is only applicable for API gateway with Standard SKU.
     * 
     * @return the configurationApi value.
     */
    public GatewayConfigurationApi configurationApi() {
        return this.configurationApi;
    }

    /**
     * Set the configurationApi property: Information regarding the Configuration API of the API Management gateway.
     * This is only applicable for API gateway with Standard SKU.
     * 
     * @param configurationApi the configurationApi value to set.
     * @return the ApiManagementGatewayBaseProperties object itself.
     */
    public ApiManagementGatewayBaseProperties withConfigurationApi(GatewayConfigurationApi configurationApi) {
        this.configurationApi = configurationApi;
        return this;
    }

    /**
     * Get the virtualNetworkType property: The type of VPN in which API Management gateway needs to be configured in.
     * 
     * @return the virtualNetworkType value.
     */
    public VirtualNetworkType virtualNetworkType() {
        return this.virtualNetworkType;
    }

    /**
     * Set the virtualNetworkType property: The type of VPN in which API Management gateway needs to be configured in.
     * 
     * @param virtualNetworkType the virtualNetworkType value to set.
     * @return the ApiManagementGatewayBaseProperties object itself.
     */
    public ApiManagementGatewayBaseProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        this.virtualNetworkType = virtualNetworkType;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (frontend() != null) {
            frontend().validate();
        }
        if (backend() != null) {
            backend().validate();
        }
        if (configurationApi() != null) {
            configurationApi().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("frontend", this.frontend);
        jsonWriter.writeJsonField("backend", this.backend);
        jsonWriter.writeJsonField("configurationApi", this.configurationApi);
        jsonWriter.writeStringField("virtualNetworkType",
            this.virtualNetworkType == null ? null : this.virtualNetworkType.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementGatewayBaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementGatewayBaseProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementGatewayBaseProperties.
     */
    public static ApiManagementGatewayBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementGatewayBaseProperties deserializedApiManagementGatewayBaseProperties
                = new ApiManagementGatewayBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.provisioningState = reader.getString();
                } else if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.targetProvisioningState = reader.getString();
                } else if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.createdAtUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("frontend".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.frontend = FrontendConfiguration.fromJson(reader);
                } else if ("backend".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.backend = BackendConfiguration.fromJson(reader);
                } else if ("configurationApi".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.configurationApi
                        = GatewayConfigurationApi.fromJson(reader);
                } else if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementGatewayBaseProperties.virtualNetworkType
                        = VirtualNetworkType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementGatewayBaseProperties;
        });
    }
}
