// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayConfigConnectionResourceInner;
import java.util.List;

/**
 * An immutable client-side representation of ApiManagementGatewayConfigConnectionResource.
 */
public interface ApiManagementGatewayConfigConnectionResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the etag property: ETag of the resource.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the provisioningState property: The current provisioning state of the API Management gateway config
     * connection.
     * 
     * @return the provisioningState value.
     */
    String provisioningState();

    /**
     * Gets the sourceId property: The link to the API Management service workspace.
     * 
     * @return the sourceId value.
     */
    String sourceId();

    /**
     * Gets the defaultHostname property: The default hostname of the data-plane gateway.
     * 
     * @return the defaultHostname value.
     */
    String defaultHostname();

    /**
     * Gets the hostnames property: The hostnames of the data-plane gateway to which requests can be sent.
     * 
     * @return the hostnames value.
     */
    List<String> hostnames();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner
     * com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayConfigConnectionResourceInner object.
     * 
     * @return the inner object.
     */
    ApiManagementGatewayConfigConnectionResourceInner innerModel();

    /**
     * The entirety of the ApiManagementGatewayConfigConnectionResource definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The ApiManagementGatewayConfigConnectionResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the ApiManagementGatewayConfigConnectionResource definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the ApiManagementGatewayConfigConnectionResource definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, gatewayName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param gatewayName The name of the API Management gateway.
             * @return the next definition stage.
             */
            WithCreate withExistingGateway(String resourceGroupName, String gatewayName);
        }

        /**
         * The stage of the ApiManagementGatewayConfigConnectionResource definition which contains all the minimum
         * required properties for the resource to be created, but also allows for any other optional properties to be
         * specified.
         */
        interface WithCreate extends DefinitionStages.WithSourceId, DefinitionStages.WithHostnames {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            ApiManagementGatewayConfigConnectionResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            ApiManagementGatewayConfigConnectionResource create(Context context);
        }

        /**
         * The stage of the ApiManagementGatewayConfigConnectionResource definition allowing to specify sourceId.
         */
        interface WithSourceId {
            /**
             * Specifies the sourceId property: The link to the API Management service workspace..
             * 
             * @param sourceId The link to the API Management service workspace.
             * @return the next definition stage.
             */
            WithCreate withSourceId(String sourceId);
        }

        /**
         * The stage of the ApiManagementGatewayConfigConnectionResource definition allowing to specify hostnames.
         */
        interface WithHostnames {
            /**
             * Specifies the hostnames property: The hostnames of the data-plane gateway to which requests can be sent..
             * 
             * @param hostnames The hostnames of the data-plane gateway to which requests can be sent.
             * @return the next definition stage.
             */
            WithCreate withHostnames(List<String> hostnames);
        }
    }

    /**
     * Begins update for the ApiManagementGatewayConfigConnectionResource resource.
     * 
     * @return the stage of resource update.
     */
    ApiManagementGatewayConfigConnectionResource.Update update();

    /**
     * The template for ApiManagementGatewayConfigConnectionResource update.
     */
    interface Update extends UpdateStages.WithSourceId, UpdateStages.WithHostnames {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        ApiManagementGatewayConfigConnectionResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        ApiManagementGatewayConfigConnectionResource apply(Context context);
    }

    /**
     * The ApiManagementGatewayConfigConnectionResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the ApiManagementGatewayConfigConnectionResource update allowing to specify sourceId.
         */
        interface WithSourceId {
            /**
             * Specifies the sourceId property: The link to the API Management service workspace..
             * 
             * @param sourceId The link to the API Management service workspace.
             * @return the next definition stage.
             */
            Update withSourceId(String sourceId);
        }

        /**
         * The stage of the ApiManagementGatewayConfigConnectionResource update allowing to specify hostnames.
         */
        interface WithHostnames {
            /**
             * Specifies the hostnames property: The hostnames of the data-plane gateway to which requests can be sent..
             * 
             * @param hostnames The hostnames of the data-plane gateway to which requests can be sent.
             * @return the next definition stage.
             */
            Update withHostnames(List<String> hostnames);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    ApiManagementGatewayConfigConnectionResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    ApiManagementGatewayConfigConnectionResource refresh(Context context);
}
