// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.management.Region;
import com.azure.core.management.SystemData;
import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * An immutable client-side representation of ApiManagementGatewayResource.
 */
public interface ApiManagementGatewayResource {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the tags property: Resource tags.
     * 
     * @return the tags value.
     */
    Map<String, String> tags();

    /**
     * Gets the sku property: SKU properties of the API Management gateway.
     * 
     * @return the sku value.
     */
    ApiManagementGatewaySkuProperties sku();

    /**
     * Gets the systemData property: Metadata pertaining to creation and last modification of the resource.
     * 
     * @return the systemData value.
     */
    SystemData systemData();

    /**
     * Gets the location property: Resource location.
     * 
     * @return the location value.
     */
    String location();

    /**
     * Gets the etag property: ETag of the resource.
     * 
     * @return the etag value.
     */
    String etag();

    /**
     * Gets the provisioningState property: The current provisioning state of the API Management gateway which can be
     * one of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @return the provisioningState value.
     */
    String provisioningState();

    /**
     * Gets the targetProvisioningState property: The provisioning state of the API Management gateway, which is
     * targeted by the long running operation started on the gateway.
     * 
     * @return the targetProvisioningState value.
     */
    String targetProvisioningState();

    /**
     * Gets the createdAtUtc property: Creation UTC date of the API Management gateway.The date conforms to the
     * following format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the createdAtUtc value.
     */
    OffsetDateTime createdAtUtc();

    /**
     * Gets the frontend property: Information regarding how the gateway should be exposed.
     * 
     * @return the frontend value.
     */
    FrontendConfiguration frontend();

    /**
     * Gets the backend property: Information regarding how the gateway should integrate with backend systems.
     * 
     * @return the backend value.
     */
    BackendConfiguration backend();

    /**
     * Gets the configurationApi property: Information regarding the Configuration API of the API Management gateway.
     * This is only applicable for API gateway with Standard SKU.
     * 
     * @return the configurationApi value.
     */
    GatewayConfigurationApi configurationApi();

    /**
     * Gets the virtualNetworkType property: The type of VPN in which API Management gateway needs to be configured in.
     * 
     * @return the virtualNetworkType value.
     */
    VirtualNetworkType virtualNetworkType();

    /**
     * Gets the region of the resource.
     * 
     * @return the region of the resource.
     */
    Region region();

    /**
     * Gets the name of the resource region.
     * 
     * @return the name of the resource region.
     */
    String regionName();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayResourceInner object.
     * 
     * @return the inner object.
     */
    ApiManagementGatewayResourceInner innerModel();

    /**
     * The entirety of the ApiManagementGatewayResource definition.
     */
    interface Definition extends DefinitionStages.Blank, DefinitionStages.WithLocation,
        DefinitionStages.WithResourceGroup, DefinitionStages.WithSku, DefinitionStages.WithCreate {
    }

    /**
     * The ApiManagementGatewayResource definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the ApiManagementGatewayResource definition.
         */
        interface Blank extends WithLocation {
        }

        /**
         * The stage of the ApiManagementGatewayResource definition allowing to specify location.
         */
        interface WithLocation {
            /**
             * Specifies the region for the resource.
             * 
             * @param location Resource location.
             * @return the next definition stage.
             */
            WithResourceGroup withRegion(Region location);

            /**
             * Specifies the region for the resource.
             * 
             * @param location Resource location.
             * @return the next definition stage.
             */
            WithResourceGroup withRegion(String location);
        }

        /**
         * The stage of the ApiManagementGatewayResource definition allowing to specify parent resource.
         */
        interface WithResourceGroup {
            /**
             * Specifies resourceGroupName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @return the next definition stage.
             */
            WithSku withExistingResourceGroup(String resourceGroupName);
        }

        /**
         * The stage of the ApiManagementGatewayResource definition allowing to specify sku.
         */
        interface WithSku {
            /**
             * Specifies the sku property: SKU properties of the API Management gateway..
             * 
             * @param sku SKU properties of the API Management gateway.
             * @return the next definition stage.
             */
            WithCreate withSku(ApiManagementGatewaySkuProperties sku);
        }

        /**
         * The stage of the ApiManagementGatewayResource definition which contains all the minimum required properties
         * for the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate
            extends DefinitionStages.WithTags, DefinitionStages.WithFrontend, DefinitionStages.WithBackend,
            DefinitionStages.WithConfigurationApi, DefinitionStages.WithVirtualNetworkType {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            ApiManagementGatewayResource create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            ApiManagementGatewayResource create(Context context);
        }

        /**
         * The stage of the ApiManagementGatewayResource definition allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Resource tags..
             * 
             * @param tags Resource tags.
             * @return the next definition stage.
             */
            WithCreate withTags(Map<String, String> tags);
        }

        /**
         * The stage of the ApiManagementGatewayResource definition allowing to specify frontend.
         */
        interface WithFrontend {
            /**
             * Specifies the frontend property: Information regarding how the gateway should be exposed..
             * 
             * @param frontend Information regarding how the gateway should be exposed.
             * @return the next definition stage.
             */
            WithCreate withFrontend(FrontendConfiguration frontend);
        }

        /**
         * The stage of the ApiManagementGatewayResource definition allowing to specify backend.
         */
        interface WithBackend {
            /**
             * Specifies the backend property: Information regarding how the gateway should integrate with backend
             * systems..
             * 
             * @param backend Information regarding how the gateway should integrate with backend systems.
             * @return the next definition stage.
             */
            WithCreate withBackend(BackendConfiguration backend);
        }

        /**
         * The stage of the ApiManagementGatewayResource definition allowing to specify configurationApi.
         */
        interface WithConfigurationApi {
            /**
             * Specifies the configurationApi property: Information regarding the Configuration API of the API
             * Management gateway. This is only applicable for API gateway with Standard SKU..
             * 
             * @param configurationApi Information regarding the Configuration API of the API Management gateway. This
             * is only applicable for API gateway with Standard SKU.
             * @return the next definition stage.
             */
            WithCreate withConfigurationApi(GatewayConfigurationApi configurationApi);
        }

        /**
         * The stage of the ApiManagementGatewayResource definition allowing to specify virtualNetworkType.
         */
        interface WithVirtualNetworkType {
            /**
             * Specifies the virtualNetworkType property: The type of VPN in which API Management gateway needs to be
             * configured in. .
             * 
             * @param virtualNetworkType The type of VPN in which API Management gateway needs to be configured in.
             * @return the next definition stage.
             */
            WithCreate withVirtualNetworkType(VirtualNetworkType virtualNetworkType);
        }
    }

    /**
     * Begins update for the ApiManagementGatewayResource resource.
     * 
     * @return the stage of resource update.
     */
    ApiManagementGatewayResource.Update update();

    /**
     * The template for ApiManagementGatewayResource update.
     */
    interface Update extends UpdateStages.WithTags, UpdateStages.WithSku, UpdateStages.WithFrontend,
        UpdateStages.WithBackend, UpdateStages.WithConfigurationApi, UpdateStages.WithVirtualNetworkType {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        ApiManagementGatewayResource apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        ApiManagementGatewayResource apply(Context context);
    }

    /**
     * The ApiManagementGatewayResource update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the ApiManagementGatewayResource update allowing to specify tags.
         */
        interface WithTags {
            /**
             * Specifies the tags property: Resource tags..
             * 
             * @param tags Resource tags.
             * @return the next definition stage.
             */
            Update withTags(Map<String, String> tags);
        }

        /**
         * The stage of the ApiManagementGatewayResource update allowing to specify sku.
         */
        interface WithSku {
            /**
             * Specifies the sku property: SKU properties of the API Management gateway..
             * 
             * @param sku SKU properties of the API Management gateway.
             * @return the next definition stage.
             */
            Update withSku(ApiManagementGatewaySkuPropertiesForPatch sku);
        }

        /**
         * The stage of the ApiManagementGatewayResource update allowing to specify frontend.
         */
        interface WithFrontend {
            /**
             * Specifies the frontend property: Information regarding how the gateway should be exposed..
             * 
             * @param frontend Information regarding how the gateway should be exposed.
             * @return the next definition stage.
             */
            Update withFrontend(FrontendConfiguration frontend);
        }

        /**
         * The stage of the ApiManagementGatewayResource update allowing to specify backend.
         */
        interface WithBackend {
            /**
             * Specifies the backend property: Information regarding how the gateway should integrate with backend
             * systems..
             * 
             * @param backend Information regarding how the gateway should integrate with backend systems.
             * @return the next definition stage.
             */
            Update withBackend(BackendConfiguration backend);
        }

        /**
         * The stage of the ApiManagementGatewayResource update allowing to specify configurationApi.
         */
        interface WithConfigurationApi {
            /**
             * Specifies the configurationApi property: Information regarding the Configuration API of the API
             * Management gateway. This is only applicable for API gateway with Standard SKU..
             * 
             * @param configurationApi Information regarding the Configuration API of the API Management gateway. This
             * is only applicable for API gateway with Standard SKU.
             * @return the next definition stage.
             */
            Update withConfigurationApi(GatewayConfigurationApi configurationApi);
        }

        /**
         * The stage of the ApiManagementGatewayResource update allowing to specify virtualNetworkType.
         */
        interface WithVirtualNetworkType {
            /**
             * Specifies the virtualNetworkType property: The type of VPN in which API Management gateway needs to be
             * configured in. .
             * 
             * @param virtualNetworkType The type of VPN in which API Management gateway needs to be configured in.
             * @return the next definition stage.
             */
            Update withVirtualNetworkType(VirtualNetworkType virtualNetworkType);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    ApiManagementGatewayResource refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    ApiManagementGatewayResource refresh(Context context);
}
