// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * API Management gateway resource SKU properties for PATCH operations given nothing should be required.
 */
@Fluent
public final class ApiManagementGatewaySkuPropertiesForPatch
    implements JsonSerializable<ApiManagementGatewaySkuPropertiesForPatch> {
    /*
     * Name of the Sku.
     */
    private ApiGatewaySkuType name;

    /*
     * Capacity of the SKU (number of deployed units of the SKU)
     */
    private Integer capacity;

    /**
     * Creates an instance of ApiManagementGatewaySkuPropertiesForPatch class.
     */
    public ApiManagementGatewaySkuPropertiesForPatch() {
    }

    /**
     * Get the name property: Name of the Sku.
     * 
     * @return the name value.
     */
    public ApiGatewaySkuType name() {
        return this.name;
    }

    /**
     * Set the name property: Name of the Sku.
     * 
     * @param name the name value to set.
     * @return the ApiManagementGatewaySkuPropertiesForPatch object itself.
     */
    public ApiManagementGatewaySkuPropertiesForPatch withName(ApiGatewaySkuType name) {
        this.name = name;
        return this;
    }

    /**
     * Get the capacity property: Capacity of the SKU (number of deployed units of the SKU).
     * 
     * @return the capacity value.
     */
    public Integer capacity() {
        return this.capacity;
    }

    /**
     * Set the capacity property: Capacity of the SKU (number of deployed units of the SKU).
     * 
     * @param capacity the capacity value to set.
     * @return the ApiManagementGatewaySkuPropertiesForPatch object itself.
     */
    public ApiManagementGatewaySkuPropertiesForPatch withCapacity(Integer capacity) {
        this.capacity = capacity;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name == null ? null : this.name.toString());
        jsonWriter.writeNumberField("capacity", this.capacity);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementGatewaySkuPropertiesForPatch from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementGatewaySkuPropertiesForPatch if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementGatewaySkuPropertiesForPatch.
     */
    public static ApiManagementGatewaySkuPropertiesForPatch fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementGatewaySkuPropertiesForPatch deserializedApiManagementGatewaySkuPropertiesForPatch
                = new ApiManagementGatewaySkuPropertiesForPatch();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApiManagementGatewaySkuPropertiesForPatch.name
                        = ApiGatewaySkuType.fromString(reader.getString());
                } else if ("capacity".equals(fieldName)) {
                    deserializedApiManagementGatewaySkuPropertiesForPatch.capacity
                        = reader.getNullable(JsonReader::getInt);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementGatewaySkuPropertiesForPatch;
        });
    }
}
