// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementGatewayUpdateProperties;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.Map;

/**
 * Parameter supplied to Update API Management gateway.
 */
@Fluent
public final class ApiManagementGatewayUpdateParameters extends ApimResource {
    /*
     * Properties of the API Management gateway.
     */
    private ApiManagementGatewayUpdateProperties innerProperties;

    /*
     * SKU properties of the API Management gateway.
     */
    private ApiManagementGatewaySkuPropertiesForPatch sku;

    /*
     * ETag of the resource.
     */
    private String etag;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of ApiManagementGatewayUpdateParameters class.
     */
    public ApiManagementGatewayUpdateParameters() {
    }

    /**
     * Get the innerProperties property: Properties of the API Management gateway.
     * 
     * @return the innerProperties value.
     */
    private ApiManagementGatewayUpdateProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the sku property: SKU properties of the API Management gateway.
     * 
     * @return the sku value.
     */
    public ApiManagementGatewaySkuPropertiesForPatch sku() {
        return this.sku;
    }

    /**
     * Set the sku property: SKU properties of the API Management gateway.
     * 
     * @param sku the sku value to set.
     * @return the ApiManagementGatewayUpdateParameters object itself.
     */
    public ApiManagementGatewayUpdateParameters withSku(ApiManagementGatewaySkuPropertiesForPatch sku) {
        this.sku = sku;
        return this;
    }

    /**
     * Get the etag property: ETag of the resource.
     * 
     * @return the etag value.
     */
    public String etag() {
        return this.etag;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public ApiManagementGatewayUpdateParameters withTags(Map<String, String> tags) {
        super.withTags(tags);
        return this;
    }

    /**
     * Get the provisioningState property: The current provisioning state of the API Management gateway which can be one
     * of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Get the targetProvisioningState property: The provisioning state of the API Management gateway, which is targeted
     * by the long running operation started on the gateway.
     * 
     * @return the targetProvisioningState value.
     */
    public String targetProvisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().targetProvisioningState();
    }

    /**
     * Get the createdAtUtc property: Creation UTC date of the API Management gateway.The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the createdAtUtc value.
     */
    public OffsetDateTime createdAtUtc() {
        return this.innerProperties() == null ? null : this.innerProperties().createdAtUtc();
    }

    /**
     * Get the frontend property: Information regarding how the gateway should be exposed.
     * 
     * @return the frontend value.
     */
    public FrontendConfiguration frontend() {
        return this.innerProperties() == null ? null : this.innerProperties().frontend();
    }

    /**
     * Set the frontend property: Information regarding how the gateway should be exposed.
     * 
     * @param frontend the frontend value to set.
     * @return the ApiManagementGatewayUpdateParameters object itself.
     */
    public ApiManagementGatewayUpdateParameters withFrontend(FrontendConfiguration frontend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayUpdateProperties();
        }
        this.innerProperties().withFrontend(frontend);
        return this;
    }

    /**
     * Get the backend property: Information regarding how the gateway should integrate with backend systems.
     * 
     * @return the backend value.
     */
    public BackendConfiguration backend() {
        return this.innerProperties() == null ? null : this.innerProperties().backend();
    }

    /**
     * Set the backend property: Information regarding how the gateway should integrate with backend systems.
     * 
     * @param backend the backend value to set.
     * @return the ApiManagementGatewayUpdateParameters object itself.
     */
    public ApiManagementGatewayUpdateParameters withBackend(BackendConfiguration backend) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayUpdateProperties();
        }
        this.innerProperties().withBackend(backend);
        return this;
    }

    /**
     * Get the configurationApi property: Information regarding the Configuration API of the API Management gateway.
     * This is only applicable for API gateway with Standard SKU.
     * 
     * @return the configurationApi value.
     */
    public GatewayConfigurationApi configurationApi() {
        return this.innerProperties() == null ? null : this.innerProperties().configurationApi();
    }

    /**
     * Set the configurationApi property: Information regarding the Configuration API of the API Management gateway.
     * This is only applicable for API gateway with Standard SKU.
     * 
     * @param configurationApi the configurationApi value to set.
     * @return the ApiManagementGatewayUpdateParameters object itself.
     */
    public ApiManagementGatewayUpdateParameters withConfigurationApi(GatewayConfigurationApi configurationApi) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayUpdateProperties();
        }
        this.innerProperties().withConfigurationApi(configurationApi);
        return this;
    }

    /**
     * Get the virtualNetworkType property: The type of VPN in which API Management gateway needs to be configured in.
     * 
     * @return the virtualNetworkType value.
     */
    public VirtualNetworkType virtualNetworkType() {
        return this.innerProperties() == null ? null : this.innerProperties().virtualNetworkType();
    }

    /**
     * Set the virtualNetworkType property: The type of VPN in which API Management gateway needs to be configured in.
     * 
     * @param virtualNetworkType the virtualNetworkType value to set.
     * @return the ApiManagementGatewayUpdateParameters object itself.
     */
    public ApiManagementGatewayUpdateParameters withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        if (this.innerProperties() == null) {
            this.innerProperties = new ApiManagementGatewayUpdateProperties();
        }
        this.innerProperties().withVirtualNetworkType(virtualNetworkType);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
        if (sku() != null) {
            sku().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeMapField("tags", tags(), (writer, element) -> writer.writeString(element));
        jsonWriter.writeJsonField("properties", this.innerProperties);
        jsonWriter.writeJsonField("sku", this.sku);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementGatewayUpdateParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementGatewayUpdateParameters if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiManagementGatewayUpdateParameters.
     */
    public static ApiManagementGatewayUpdateParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementGatewayUpdateParameters deserializedApiManagementGatewayUpdateParameters
                = new ApiManagementGatewayUpdateParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.type = reader.getString();
                } else if ("tags".equals(fieldName)) {
                    Map<String, String> tags = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementGatewayUpdateParameters.withTags(tags);
                } else if ("properties".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.innerProperties
                        = ApiManagementGatewayUpdateProperties.fromJson(reader);
                } else if ("sku".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.sku
                        = ApiManagementGatewaySkuPropertiesForPatch.fromJson(reader);
                } else if ("etag".equals(fieldName)) {
                    deserializedApiManagementGatewayUpdateParameters.etag = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementGatewayUpdateParameters;
        });
    }
}
