// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Parameters supplied to the Backup/Restore of an API Management service operation.
 */
@Fluent
public final class ApiManagementServiceBackupRestoreParameters
    implements JsonSerializable<ApiManagementServiceBackupRestoreParameters> {
    /*
     * The name of the Azure storage account (used to place/retrieve the backup).
     */
    private String storageAccount;

    /*
     * The name of the blob container (used to place/retrieve the backup).
     */
    private String containerName;

    /*
     * The name of the backup file to create/retrieve.
     */
    private String backupName;

    /*
     * The type of access to be used for the storage account.
     */
    private AccessType accessType;

    /*
     * Storage account access key. Required only if `accessType` is set to `AccessKey`.
     */
    private String accessKey;

    /*
     * The Client ID of user assigned managed identity. Required only if `accessType` is set to
     * `UserAssignedManagedIdentity`.
     */
    private String clientId;

    /**
     * Creates an instance of ApiManagementServiceBackupRestoreParameters class.
     */
    public ApiManagementServiceBackupRestoreParameters() {
    }

    /**
     * Get the storageAccount property: The name of the Azure storage account (used to place/retrieve the backup).
     * 
     * @return the storageAccount value.
     */
    public String storageAccount() {
        return this.storageAccount;
    }

    /**
     * Set the storageAccount property: The name of the Azure storage account (used to place/retrieve the backup).
     * 
     * @param storageAccount the storageAccount value to set.
     * @return the ApiManagementServiceBackupRestoreParameters object itself.
     */
    public ApiManagementServiceBackupRestoreParameters withStorageAccount(String storageAccount) {
        this.storageAccount = storageAccount;
        return this;
    }

    /**
     * Get the containerName property: The name of the blob container (used to place/retrieve the backup).
     * 
     * @return the containerName value.
     */
    public String containerName() {
        return this.containerName;
    }

    /**
     * Set the containerName property: The name of the blob container (used to place/retrieve the backup).
     * 
     * @param containerName the containerName value to set.
     * @return the ApiManagementServiceBackupRestoreParameters object itself.
     */
    public ApiManagementServiceBackupRestoreParameters withContainerName(String containerName) {
        this.containerName = containerName;
        return this;
    }

    /**
     * Get the backupName property: The name of the backup file to create/retrieve.
     * 
     * @return the backupName value.
     */
    public String backupName() {
        return this.backupName;
    }

    /**
     * Set the backupName property: The name of the backup file to create/retrieve.
     * 
     * @param backupName the backupName value to set.
     * @return the ApiManagementServiceBackupRestoreParameters object itself.
     */
    public ApiManagementServiceBackupRestoreParameters withBackupName(String backupName) {
        this.backupName = backupName;
        return this;
    }

    /**
     * Get the accessType property: The type of access to be used for the storage account.
     * 
     * @return the accessType value.
     */
    public AccessType accessType() {
        return this.accessType;
    }

    /**
     * Set the accessType property: The type of access to be used for the storage account.
     * 
     * @param accessType the accessType value to set.
     * @return the ApiManagementServiceBackupRestoreParameters object itself.
     */
    public ApiManagementServiceBackupRestoreParameters withAccessType(AccessType accessType) {
        this.accessType = accessType;
        return this;
    }

    /**
     * Get the accessKey property: Storage account access key. Required only if `accessType` is set to `AccessKey`.
     * 
     * @return the accessKey value.
     */
    public String accessKey() {
        return this.accessKey;
    }

    /**
     * Set the accessKey property: Storage account access key. Required only if `accessType` is set to `AccessKey`.
     * 
     * @param accessKey the accessKey value to set.
     * @return the ApiManagementServiceBackupRestoreParameters object itself.
     */
    public ApiManagementServiceBackupRestoreParameters withAccessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    /**
     * Get the clientId property: The Client ID of user assigned managed identity. Required only if `accessType` is set
     * to `UserAssignedManagedIdentity`.
     * 
     * @return the clientId value.
     */
    public String clientId() {
        return this.clientId;
    }

    /**
     * Set the clientId property: The Client ID of user assigned managed identity. Required only if `accessType` is set
     * to `UserAssignedManagedIdentity`.
     * 
     * @param clientId the clientId value to set.
     * @return the ApiManagementServiceBackupRestoreParameters object itself.
     */
    public ApiManagementServiceBackupRestoreParameters withClientId(String clientId) {
        this.clientId = clientId;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (storageAccount() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property storageAccount in model ApiManagementServiceBackupRestoreParameters"));
        }
        if (containerName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property containerName in model ApiManagementServiceBackupRestoreParameters"));
        }
        if (backupName() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property backupName in model ApiManagementServiceBackupRestoreParameters"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceBackupRestoreParameters.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("storageAccount", this.storageAccount);
        jsonWriter.writeStringField("containerName", this.containerName);
        jsonWriter.writeStringField("backupName", this.backupName);
        jsonWriter.writeStringField("accessType", this.accessType == null ? null : this.accessType.toString());
        jsonWriter.writeStringField("accessKey", this.accessKey);
        jsonWriter.writeStringField("clientId", this.clientId);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementServiceBackupRestoreParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementServiceBackupRestoreParameters if the JsonReader was pointing to an instance
     * of it, or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiManagementServiceBackupRestoreParameters.
     */
    public static ApiManagementServiceBackupRestoreParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementServiceBackupRestoreParameters deserializedApiManagementServiceBackupRestoreParameters
                = new ApiManagementServiceBackupRestoreParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("storageAccount".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.storageAccount = reader.getString();
                } else if ("containerName".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.containerName = reader.getString();
                } else if ("backupName".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.backupName = reader.getString();
                } else if ("accessType".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.accessType
                        = AccessType.fromString(reader.getString());
                } else if ("accessKey".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.accessKey = reader.getString();
                } else if ("clientId".equals(fieldName)) {
                    deserializedApiManagementServiceBackupRestoreParameters.clientId = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementServiceBackupRestoreParameters;
        });
    }
}
