// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.CoreUtils;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Map;

/**
 * Base Properties of an API Management service resource description.
 */
@Fluent
public class ApiManagementServiceBaseProperties implements JsonSerializable<ApiManagementServiceBaseProperties> {
    /*
     * Email address from which the notification will be sent.
     */
    private String notificationSenderEmail;

    /*
     * The current provisioning state of the API Management service which can be one of the following:
     * Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     */
    private String provisioningState;

    /*
     * The provisioning state of the API Management service, which is targeted by the long running operation started on
     * the service.
     */
    private String targetProvisioningState;

    /*
     * Creation UTC date of the API Management service.The date conforms to the following format: `yyyy-MM-ddTHH:mm:ssZ`
     * as specified by the ISO 8601 standard.
     */
    private OffsetDateTime createdAtUtc;

    /*
     * Gateway URL of the API Management service.
     */
    private String gatewayUrl;

    /*
     * Gateway URL of the API Management service in the Default Region.
     */
    private String gatewayRegionalUrl;

    /*
     * Publisher portal endpoint Url of the API Management service.
     */
    private String portalUrl;

    /*
     * Management API endpoint URL of the API Management service.
     */
    private String managementApiUrl;

    /*
     * SCM endpoint URL of the API Management service.
     */
    private String scmUrl;

    /*
     * DEveloper Portal endpoint URL of the API Management service.
     */
    private String developerPortalUrl;

    /*
     * Custom hostname configuration of the API Management service.
     */
    private List<HostnameConfiguration> hostnameConfigurations;

    /*
     * Public Static Load Balanced IP addresses of the API Management service in Primary region. Available only for
     * Basic, Standard, Premium and Isolated SKU.
     */
    private List<String> publicIpAddresses;

    /*
     * Private Static Load Balanced IP addresses of the API Management service in Primary region which is deployed in an
     * Internal Virtual Network. Available only for Basic, Standard, Premium and Isolated SKU.
     */
    private List<String> privateIpAddresses;

    /*
     * Public Standard SKU IP V4 based IP address to be associated with Virtual Network deployed service in the region.
     * Supported only for Developer and Premium SKU being deployed in Virtual Network.
     */
    private String publicIpAddressId;

    /*
     * Whether or not public endpoint access is allowed for this API Management service. Value is optional but if passed
     * in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints are the exclusive access method. Default
     * value is 'Enabled'
     */
    private PublicNetworkAccess publicNetworkAccess;

    /*
     * Configuration API configuration of the API Management service.
     */
    private ConfigurationApi configurationApi;

    /*
     * Virtual network configuration of the API Management service.
     */
    private VirtualNetworkConfiguration virtualNetworkConfiguration;

    /*
     * Additional datacenter locations of the API Management service.
     */
    private List<AdditionalLocation> additionalLocations;

    /*
     * Custom properties of the API Management service.</br>Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher
     * TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).</br>Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS
     * 1.1.</br>Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to disable
     * TLS 1.0 on an API Management service.</br>Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS
     * 1.1 for communications with backends.</br>Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0
     * for communications with backends.</br>Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an
     * API Management service.</br>Not specifying any of these properties on PATCH operation will reset omitted
     * properties' values to their defaults. For all the settings except Http2 the default value is `True` if the
     * service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is
     * `False`.</br></br>You can disable any of the following ciphers by using settings
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     * TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,
     * TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     * TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example,
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The
     * default value is `true` for them.</br> Note: The following ciphers can't be disabled since they are required by
     * internal platform components:
     * TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,
     * TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,
     * TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,
     * TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,
     * TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256
     */
    private Map<String, String> customProperties;

    /*
     * List of Certificates that need to be installed in the API Management service. Max supported certificates that can
     * be installed is 10.
     */
    private List<CertificateConfiguration> certificates;

    /*
     * Property only meant to be used for Consumption SKU Service. This enforces a client certificate to be presented on
     * each request to the gateway. This also enables the ability to authenticate the certificate in the policy on the
     * gateway.
     */
    private Boolean enableClientCertificate;

    /*
     * Property can be used to enable NAT Gateway for this API Management service.
     */
    private NatGatewayState natGatewayState;

    /*
     * Outbound public IPV4 address prefixes associated with NAT Gateway deployed service. Available only for Premium
     * SKU on stv2 platform.
     */
    private List<String> outboundPublicIpAddresses;

    /*
     * Property only valid for an Api Management service deployed in multiple locations. This can be used to disable the
     * gateway in master region.
     */
    private Boolean disableGateway;

    /*
     * The type of VPN in which API Management service needs to be configured in. None (Default Value) means the API
     * Management service is not part of any Virtual Network, External means the API Management deployment is set up
     * inside a Virtual Network having an Internet Facing Endpoint, and Internal means that API Management deployment is
     * setup inside a Virtual Network having an Intranet Facing Endpoint only.
     */
    private VirtualNetworkType virtualNetworkType;

    /*
     * Control Plane Apis version constraint for the API Management service.
     */
    private ApiVersionConstraint apiVersionConstraint;

    /*
     * Undelete Api Management Service if it was previously soft-deleted. If this flag is specified and set to True all
     * other properties will be ignored.
     */
    private Boolean restore;

    /*
     * List of Private Endpoint Connections of this service.
     */
    private List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections;

    /*
     * Compute Platform Version running the service in this location.
     */
    private PlatformVersion platformVersion;

    /*
     * Status of legacy portal in the API Management service.
     */
    private LegacyPortalStatus legacyPortalStatus;

    /*
     * Status of developer portal in this API Management service.
     */
    private DeveloperPortalStatus developerPortalStatus;

    /**
     * Creates an instance of ApiManagementServiceBaseProperties class.
     */
    public ApiManagementServiceBaseProperties() {
    }

    /**
     * Get the notificationSenderEmail property: Email address from which the notification will be sent.
     * 
     * @return the notificationSenderEmail value.
     */
    public String notificationSenderEmail() {
        return this.notificationSenderEmail;
    }

    /**
     * Set the notificationSenderEmail property: Email address from which the notification will be sent.
     * 
     * @param notificationSenderEmail the notificationSenderEmail value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withNotificationSenderEmail(String notificationSenderEmail) {
        this.notificationSenderEmail = notificationSenderEmail;
        return this;
    }

    /**
     * Get the provisioningState property: The current provisioning state of the API Management service which can be one
     * of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @return the provisioningState value.
     */
    public String provisioningState() {
        return this.provisioningState;
    }

    /**
     * Set the provisioningState property: The current provisioning state of the API Management service which can be one
     * of the following: Created/Activating/Succeeded/Updating/Failed/Stopped/Terminating/TerminationFailed/Deleted.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withProvisioningState(String provisioningState) {
        this.provisioningState = provisioningState;
        return this;
    }

    /**
     * Get the targetProvisioningState property: The provisioning state of the API Management service, which is targeted
     * by the long running operation started on the service.
     * 
     * @return the targetProvisioningState value.
     */
    public String targetProvisioningState() {
        return this.targetProvisioningState;
    }

    /**
     * Set the targetProvisioningState property: The provisioning state of the API Management service, which is targeted
     * by the long running operation started on the service.
     * 
     * @param targetProvisioningState the targetProvisioningState value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withTargetProvisioningState(String targetProvisioningState) {
        this.targetProvisioningState = targetProvisioningState;
        return this;
    }

    /**
     * Get the createdAtUtc property: Creation UTC date of the API Management service.The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @return the createdAtUtc value.
     */
    public OffsetDateTime createdAtUtc() {
        return this.createdAtUtc;
    }

    /**
     * Set the createdAtUtc property: Creation UTC date of the API Management service.The date conforms to the following
     * format: `yyyy-MM-ddTHH:mm:ssZ` as specified by the ISO 8601 standard.
     * 
     * @param createdAtUtc the createdAtUtc value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withCreatedAtUtc(OffsetDateTime createdAtUtc) {
        this.createdAtUtc = createdAtUtc;
        return this;
    }

    /**
     * Get the gatewayUrl property: Gateway URL of the API Management service.
     * 
     * @return the gatewayUrl value.
     */
    public String gatewayUrl() {
        return this.gatewayUrl;
    }

    /**
     * Set the gatewayUrl property: Gateway URL of the API Management service.
     * 
     * @param gatewayUrl the gatewayUrl value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withGatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
        return this;
    }

    /**
     * Get the gatewayRegionalUrl property: Gateway URL of the API Management service in the Default Region.
     * 
     * @return the gatewayRegionalUrl value.
     */
    public String gatewayRegionalUrl() {
        return this.gatewayRegionalUrl;
    }

    /**
     * Set the gatewayRegionalUrl property: Gateway URL of the API Management service in the Default Region.
     * 
     * @param gatewayRegionalUrl the gatewayRegionalUrl value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withGatewayRegionalUrl(String gatewayRegionalUrl) {
        this.gatewayRegionalUrl = gatewayRegionalUrl;
        return this;
    }

    /**
     * Get the portalUrl property: Publisher portal endpoint Url of the API Management service.
     * 
     * @return the portalUrl value.
     */
    public String portalUrl() {
        return this.portalUrl;
    }

    /**
     * Set the portalUrl property: Publisher portal endpoint Url of the API Management service.
     * 
     * @param portalUrl the portalUrl value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withPortalUrl(String portalUrl) {
        this.portalUrl = portalUrl;
        return this;
    }

    /**
     * Get the managementApiUrl property: Management API endpoint URL of the API Management service.
     * 
     * @return the managementApiUrl value.
     */
    public String managementApiUrl() {
        return this.managementApiUrl;
    }

    /**
     * Set the managementApiUrl property: Management API endpoint URL of the API Management service.
     * 
     * @param managementApiUrl the managementApiUrl value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withManagementApiUrl(String managementApiUrl) {
        this.managementApiUrl = managementApiUrl;
        return this;
    }

    /**
     * Get the scmUrl property: SCM endpoint URL of the API Management service.
     * 
     * @return the scmUrl value.
     */
    public String scmUrl() {
        return this.scmUrl;
    }

    /**
     * Set the scmUrl property: SCM endpoint URL of the API Management service.
     * 
     * @param scmUrl the scmUrl value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withScmUrl(String scmUrl) {
        this.scmUrl = scmUrl;
        return this;
    }

    /**
     * Get the developerPortalUrl property: DEveloper Portal endpoint URL of the API Management service.
     * 
     * @return the developerPortalUrl value.
     */
    public String developerPortalUrl() {
        return this.developerPortalUrl;
    }

    /**
     * Set the developerPortalUrl property: DEveloper Portal endpoint URL of the API Management service.
     * 
     * @param developerPortalUrl the developerPortalUrl value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withDeveloperPortalUrl(String developerPortalUrl) {
        this.developerPortalUrl = developerPortalUrl;
        return this;
    }

    /**
     * Get the hostnameConfigurations property: Custom hostname configuration of the API Management service.
     * 
     * @return the hostnameConfigurations value.
     */
    public List<HostnameConfiguration> hostnameConfigurations() {
        return this.hostnameConfigurations;
    }

    /**
     * Set the hostnameConfigurations property: Custom hostname configuration of the API Management service.
     * 
     * @param hostnameConfigurations the hostnameConfigurations value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties
        withHostnameConfigurations(List<HostnameConfiguration> hostnameConfigurations) {
        this.hostnameConfigurations = hostnameConfigurations;
        return this;
    }

    /**
     * Get the publicIpAddresses property: Public Static Load Balanced IP addresses of the API Management service in
     * Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
     * 
     * @return the publicIpAddresses value.
     */
    public List<String> publicIpAddresses() {
        return this.publicIpAddresses;
    }

    /**
     * Set the publicIpAddresses property: Public Static Load Balanced IP addresses of the API Management service in
     * Primary region. Available only for Basic, Standard, Premium and Isolated SKU.
     * 
     * @param publicIpAddresses the publicIpAddresses value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withPublicIpAddresses(List<String> publicIpAddresses) {
        this.publicIpAddresses = publicIpAddresses;
        return this;
    }

    /**
     * Get the privateIpAddresses property: Private Static Load Balanced IP addresses of the API Management service in
     * Primary region which is deployed in an Internal Virtual Network. Available only for Basic, Standard, Premium and
     * Isolated SKU.
     * 
     * @return the privateIpAddresses value.
     */
    public List<String> privateIpAddresses() {
        return this.privateIpAddresses;
    }

    /**
     * Set the privateIpAddresses property: Private Static Load Balanced IP addresses of the API Management service in
     * Primary region which is deployed in an Internal Virtual Network. Available only for Basic, Standard, Premium and
     * Isolated SKU.
     * 
     * @param privateIpAddresses the privateIpAddresses value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withPrivateIpAddresses(List<String> privateIpAddresses) {
        this.privateIpAddresses = privateIpAddresses;
        return this;
    }

    /**
     * Get the publicIpAddressId property: Public Standard SKU IP V4 based IP address to be associated with Virtual
     * Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual
     * Network.
     * 
     * @return the publicIpAddressId value.
     */
    public String publicIpAddressId() {
        return this.publicIpAddressId;
    }

    /**
     * Set the publicIpAddressId property: Public Standard SKU IP V4 based IP address to be associated with Virtual
     * Network deployed service in the region. Supported only for Developer and Premium SKU being deployed in Virtual
     * Network.
     * 
     * @param publicIpAddressId the publicIpAddressId value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withPublicIpAddressId(String publicIpAddressId) {
        this.publicIpAddressId = publicIpAddressId;
        return this;
    }

    /**
     * Get the publicNetworkAccess property: Whether or not public endpoint access is allowed for this API Management
     * service. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints
     * are the exclusive access method. Default value is 'Enabled'.
     * 
     * @return the publicNetworkAccess value.
     */
    public PublicNetworkAccess publicNetworkAccess() {
        return this.publicNetworkAccess;
    }

    /**
     * Set the publicNetworkAccess property: Whether or not public endpoint access is allowed for this API Management
     * service. Value is optional but if passed in, must be 'Enabled' or 'Disabled'. If 'Disabled', private endpoints
     * are the exclusive access method. Default value is 'Enabled'.
     * 
     * @param publicNetworkAccess the publicNetworkAccess value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withPublicNetworkAccess(PublicNetworkAccess publicNetworkAccess) {
        this.publicNetworkAccess = publicNetworkAccess;
        return this;
    }

    /**
     * Get the configurationApi property: Configuration API configuration of the API Management service.
     * 
     * @return the configurationApi value.
     */
    public ConfigurationApi configurationApi() {
        return this.configurationApi;
    }

    /**
     * Set the configurationApi property: Configuration API configuration of the API Management service.
     * 
     * @param configurationApi the configurationApi value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withConfigurationApi(ConfigurationApi configurationApi) {
        this.configurationApi = configurationApi;
        return this;
    }

    /**
     * Get the virtualNetworkConfiguration property: Virtual network configuration of the API Management service.
     * 
     * @return the virtualNetworkConfiguration value.
     */
    public VirtualNetworkConfiguration virtualNetworkConfiguration() {
        return this.virtualNetworkConfiguration;
    }

    /**
     * Set the virtualNetworkConfiguration property: Virtual network configuration of the API Management service.
     * 
     * @param virtualNetworkConfiguration the virtualNetworkConfiguration value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties
        withVirtualNetworkConfiguration(VirtualNetworkConfiguration virtualNetworkConfiguration) {
        this.virtualNetworkConfiguration = virtualNetworkConfiguration;
        return this;
    }

    /**
     * Get the additionalLocations property: Additional datacenter locations of the API Management service.
     * 
     * @return the additionalLocations value.
     */
    public List<AdditionalLocation> additionalLocations() {
        return this.additionalLocations;
    }

    /**
     * Set the additionalLocations property: Additional datacenter locations of the API Management service.
     * 
     * @param additionalLocations the additionalLocations value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withAdditionalLocations(List<AdditionalLocation> additionalLocations) {
        this.additionalLocations = additionalLocations;
        return this;
    }

    /**
     * Get the customProperties property: Custom properties of the API Management service.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher
     * TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS
     * 1.1.&lt;/br&gt;Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to
     * disable TLS 1.0 on an API Management service.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS
     * 1.1 for communications with backends.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0
     * for communications with backends.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an
     * API Management service.&lt;/br&gt;Not specifying any of these properties on PATCH operation will reset omitted
     * properties' values to their defaults. For all the settings except Http2 the default value is `True` if the
     * service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is
     * `False`.&lt;/br&gt;&lt;/br&gt;You can disable any of the following ciphers by using settings
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     * TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,
     * TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     * TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example,
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The
     * default value is `true` for them.&lt;/br&gt; Note: The following ciphers can't be disabled since they are
     * required by internal platform components:
     * TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256.
     * 
     * @return the customProperties value.
     */
    public Map<String, String> customProperties() {
        return this.customProperties;
    }

    /**
     * Set the customProperties property: Custom properties of the API Management service.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TripleDes168` will disable the cipher
     * TLS_RSA_WITH_3DES_EDE_CBC_SHA for all TLS(1.0, 1.1 and 1.2).&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls11` can be used to disable just TLS
     * 1.1.&lt;/br&gt;Setting `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Protocols.Tls10` can be used to
     * disable TLS 1.0 on an API Management service.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls11` can be used to disable just TLS
     * 1.1 for communications with backends.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Backend.Protocols.Tls10` can be used to disable TLS 1.0
     * for communications with backends.&lt;/br&gt;Setting
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Protocols.Server.Http2` can be used to enable HTTP2 protocol on an
     * API Management service.&lt;/br&gt;Not specifying any of these properties on PATCH operation will reset omitted
     * properties' values to their defaults. For all the settings except Http2 the default value is `True` if the
     * service was created on or before April 1, 2018 and `False` otherwise. Http2 setting's default value is
     * `False`.&lt;/br&gt;&lt;/br&gt;You can disable any of the following ciphers by using settings
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.[cipher_name]`:
     * TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA, TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA, TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA,
     * TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA, TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA256,
     * TLS_RSA_WITH_AES_128_CBC_SHA256, TLS_RSA_WITH_AES_256_CBC_SHA, TLS_RSA_WITH_AES_128_CBC_SHA. For example,
     * `Microsoft.WindowsAzure.ApiManagement.Gateway.Security.Ciphers.TLS_RSA_WITH_AES_128_CBC_SHA256`:`false`. The
     * default value is `true` for them.&lt;/br&gt; Note: The following ciphers can't be disabled since they are
     * required by internal platform components:
     * TLS_AES_256_GCM_SHA384,TLS_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_RSA_WITH_AES_256_GCM_SHA384,TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_ECDSA_WITH_AES_128_CBC_SHA256,TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA384,TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256.
     * 
     * @param customProperties the customProperties value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
        return this;
    }

    /**
     * Get the certificates property: List of Certificates that need to be installed in the API Management service. Max
     * supported certificates that can be installed is 10.
     * 
     * @return the certificates value.
     */
    public List<CertificateConfiguration> certificates() {
        return this.certificates;
    }

    /**
     * Set the certificates property: List of Certificates that need to be installed in the API Management service. Max
     * supported certificates that can be installed is 10.
     * 
     * @param certificates the certificates value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withCertificates(List<CertificateConfiguration> certificates) {
        this.certificates = certificates;
        return this;
    }

    /**
     * Get the enableClientCertificate property: Property only meant to be used for Consumption SKU Service. This
     * enforces a client certificate to be presented on each request to the gateway. This also enables the ability to
     * authenticate the certificate in the policy on the gateway.
     * 
     * @return the enableClientCertificate value.
     */
    public Boolean enableClientCertificate() {
        return this.enableClientCertificate;
    }

    /**
     * Set the enableClientCertificate property: Property only meant to be used for Consumption SKU Service. This
     * enforces a client certificate to be presented on each request to the gateway. This also enables the ability to
     * authenticate the certificate in the policy on the gateway.
     * 
     * @param enableClientCertificate the enableClientCertificate value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withEnableClientCertificate(Boolean enableClientCertificate) {
        this.enableClientCertificate = enableClientCertificate;
        return this;
    }

    /**
     * Get the natGatewayState property: Property can be used to enable NAT Gateway for this API Management service.
     * 
     * @return the natGatewayState value.
     */
    public NatGatewayState natGatewayState() {
        return this.natGatewayState;
    }

    /**
     * Set the natGatewayState property: Property can be used to enable NAT Gateway for this API Management service.
     * 
     * @param natGatewayState the natGatewayState value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withNatGatewayState(NatGatewayState natGatewayState) {
        this.natGatewayState = natGatewayState;
        return this;
    }

    /**
     * Get the outboundPublicIpAddresses property: Outbound public IPV4 address prefixes associated with NAT Gateway
     * deployed service. Available only for Premium SKU on stv2 platform.
     * 
     * @return the outboundPublicIpAddresses value.
     */
    public List<String> outboundPublicIpAddresses() {
        return this.outboundPublicIpAddresses;
    }

    /**
     * Set the outboundPublicIpAddresses property: Outbound public IPV4 address prefixes associated with NAT Gateway
     * deployed service. Available only for Premium SKU on stv2 platform.
     * 
     * @param outboundPublicIpAddresses the outboundPublicIpAddresses value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withOutboundPublicIpAddresses(List<String> outboundPublicIpAddresses) {
        this.outboundPublicIpAddresses = outboundPublicIpAddresses;
        return this;
    }

    /**
     * Get the disableGateway property: Property only valid for an Api Management service deployed in multiple
     * locations. This can be used to disable the gateway in master region.
     * 
     * @return the disableGateway value.
     */
    public Boolean disableGateway() {
        return this.disableGateway;
    }

    /**
     * Set the disableGateway property: Property only valid for an Api Management service deployed in multiple
     * locations. This can be used to disable the gateway in master region.
     * 
     * @param disableGateway the disableGateway value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withDisableGateway(Boolean disableGateway) {
        this.disableGateway = disableGateway;
        return this;
    }

    /**
     * Get the virtualNetworkType property: The type of VPN in which API Management service needs to be configured in.
     * None (Default Value) means the API Management service is not part of any Virtual Network, External means the API
     * Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means
     * that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     * 
     * @return the virtualNetworkType value.
     */
    public VirtualNetworkType virtualNetworkType() {
        return this.virtualNetworkType;
    }

    /**
     * Set the virtualNetworkType property: The type of VPN in which API Management service needs to be configured in.
     * None (Default Value) means the API Management service is not part of any Virtual Network, External means the API
     * Management deployment is set up inside a Virtual Network having an Internet Facing Endpoint, and Internal means
     * that API Management deployment is setup inside a Virtual Network having an Intranet Facing Endpoint only.
     * 
     * @param virtualNetworkType the virtualNetworkType value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withVirtualNetworkType(VirtualNetworkType virtualNetworkType) {
        this.virtualNetworkType = virtualNetworkType;
        return this;
    }

    /**
     * Get the apiVersionConstraint property: Control Plane Apis version constraint for the API Management service.
     * 
     * @return the apiVersionConstraint value.
     */
    public ApiVersionConstraint apiVersionConstraint() {
        return this.apiVersionConstraint;
    }

    /**
     * Set the apiVersionConstraint property: Control Plane Apis version constraint for the API Management service.
     * 
     * @param apiVersionConstraint the apiVersionConstraint value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withApiVersionConstraint(ApiVersionConstraint apiVersionConstraint) {
        this.apiVersionConstraint = apiVersionConstraint;
        return this;
    }

    /**
     * Get the restore property: Undelete Api Management Service if it was previously soft-deleted. If this flag is
     * specified and set to True all other properties will be ignored.
     * 
     * @return the restore value.
     */
    public Boolean restore() {
        return this.restore;
    }

    /**
     * Set the restore property: Undelete Api Management Service if it was previously soft-deleted. If this flag is
     * specified and set to True all other properties will be ignored.
     * 
     * @param restore the restore value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withRestore(Boolean restore) {
        this.restore = restore;
        return this;
    }

    /**
     * Get the privateEndpointConnections property: List of Private Endpoint Connections of this service.
     * 
     * @return the privateEndpointConnections value.
     */
    public List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections() {
        return this.privateEndpointConnections;
    }

    /**
     * Set the privateEndpointConnections property: List of Private Endpoint Connections of this service.
     * 
     * @param privateEndpointConnections the privateEndpointConnections value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties
        withPrivateEndpointConnections(List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections) {
        this.privateEndpointConnections = privateEndpointConnections;
        return this;
    }

    /**
     * Get the platformVersion property: Compute Platform Version running the service in this location.
     * 
     * @return the platformVersion value.
     */
    public PlatformVersion platformVersion() {
        return this.platformVersion;
    }

    /**
     * Set the platformVersion property: Compute Platform Version running the service in this location.
     * 
     * @param platformVersion the platformVersion value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    ApiManagementServiceBaseProperties withPlatformVersion(PlatformVersion platformVersion) {
        this.platformVersion = platformVersion;
        return this;
    }

    /**
     * Get the legacyPortalStatus property: Status of legacy portal in the API Management service.
     * 
     * @return the legacyPortalStatus value.
     */
    public LegacyPortalStatus legacyPortalStatus() {
        return this.legacyPortalStatus;
    }

    /**
     * Set the legacyPortalStatus property: Status of legacy portal in the API Management service.
     * 
     * @param legacyPortalStatus the legacyPortalStatus value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withLegacyPortalStatus(LegacyPortalStatus legacyPortalStatus) {
        this.legacyPortalStatus = legacyPortalStatus;
        return this;
    }

    /**
     * Get the developerPortalStatus property: Status of developer portal in this API Management service.
     * 
     * @return the developerPortalStatus value.
     */
    public DeveloperPortalStatus developerPortalStatus() {
        return this.developerPortalStatus;
    }

    /**
     * Set the developerPortalStatus property: Status of developer portal in this API Management service.
     * 
     * @param developerPortalStatus the developerPortalStatus value to set.
     * @return the ApiManagementServiceBaseProperties object itself.
     */
    public ApiManagementServiceBaseProperties withDeveloperPortalStatus(DeveloperPortalStatus developerPortalStatus) {
        this.developerPortalStatus = developerPortalStatus;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (hostnameConfigurations() != null) {
            hostnameConfigurations().forEach(e -> e.validate());
        }
        if (configurationApi() != null) {
            configurationApi().validate();
        }
        if (virtualNetworkConfiguration() != null) {
            virtualNetworkConfiguration().validate();
        }
        if (additionalLocations() != null) {
            additionalLocations().forEach(e -> e.validate());
        }
        if (certificates() != null) {
            certificates().forEach(e -> e.validate());
        }
        if (apiVersionConstraint() != null) {
            apiVersionConstraint().validate();
        }
        if (privateEndpointConnections() != null) {
            privateEndpointConnections().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("notificationSenderEmail", this.notificationSenderEmail);
        jsonWriter.writeArrayField("hostnameConfigurations", this.hostnameConfigurations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("publicIpAddressId", this.publicIpAddressId);
        jsonWriter.writeStringField("publicNetworkAccess",
            this.publicNetworkAccess == null ? null : this.publicNetworkAccess.toString());
        jsonWriter.writeJsonField("configurationApi", this.configurationApi);
        jsonWriter.writeJsonField("virtualNetworkConfiguration", this.virtualNetworkConfiguration);
        jsonWriter.writeArrayField("additionalLocations", this.additionalLocations,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeMapField("customProperties", this.customProperties,
            (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("certificates", this.certificates, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeBooleanField("enableClientCertificate", this.enableClientCertificate);
        jsonWriter.writeStringField("natGatewayState",
            this.natGatewayState == null ? null : this.natGatewayState.toString());
        jsonWriter.writeBooleanField("disableGateway", this.disableGateway);
        jsonWriter.writeStringField("virtualNetworkType",
            this.virtualNetworkType == null ? null : this.virtualNetworkType.toString());
        jsonWriter.writeJsonField("apiVersionConstraint", this.apiVersionConstraint);
        jsonWriter.writeBooleanField("restore", this.restore);
        jsonWriter.writeArrayField("privateEndpointConnections", this.privateEndpointConnections,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("legacyPortalStatus",
            this.legacyPortalStatus == null ? null : this.legacyPortalStatus.toString());
        jsonWriter.writeStringField("developerPortalStatus",
            this.developerPortalStatus == null ? null : this.developerPortalStatus.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementServiceBaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementServiceBaseProperties if the JsonReader was pointing to an instance of it, or
     * null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementServiceBaseProperties.
     */
    public static ApiManagementServiceBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementServiceBaseProperties deserializedApiManagementServiceBaseProperties
                = new ApiManagementServiceBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("notificationSenderEmail".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.notificationSenderEmail = reader.getString();
                } else if ("provisioningState".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.provisioningState = reader.getString();
                } else if ("targetProvisioningState".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.targetProvisioningState = reader.getString();
                } else if ("createdAtUtc".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.createdAtUtc = reader
                        .getNullable(nonNullReader -> CoreUtils.parseBestOffsetDateTime(nonNullReader.getString()));
                } else if ("gatewayUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.gatewayUrl = reader.getString();
                } else if ("gatewayRegionalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.gatewayRegionalUrl = reader.getString();
                } else if ("portalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.portalUrl = reader.getString();
                } else if ("managementApiUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.managementApiUrl = reader.getString();
                } else if ("scmUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.scmUrl = reader.getString();
                } else if ("developerPortalUrl".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.developerPortalUrl = reader.getString();
                } else if ("hostnameConfigurations".equals(fieldName)) {
                    List<HostnameConfiguration> hostnameConfigurations
                        = reader.readArray(reader1 -> HostnameConfiguration.fromJson(reader1));
                    deserializedApiManagementServiceBaseProperties.hostnameConfigurations = hostnameConfigurations;
                } else if ("publicIPAddresses".equals(fieldName)) {
                    List<String> publicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedApiManagementServiceBaseProperties.publicIpAddresses = publicIpAddresses;
                } else if ("privateIPAddresses".equals(fieldName)) {
                    List<String> privateIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedApiManagementServiceBaseProperties.privateIpAddresses = privateIpAddresses;
                } else if ("publicIpAddressId".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.publicIpAddressId = reader.getString();
                } else if ("publicNetworkAccess".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.publicNetworkAccess
                        = PublicNetworkAccess.fromString(reader.getString());
                } else if ("configurationApi".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.configurationApi = ConfigurationApi.fromJson(reader);
                } else if ("virtualNetworkConfiguration".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.virtualNetworkConfiguration
                        = VirtualNetworkConfiguration.fromJson(reader);
                } else if ("additionalLocations".equals(fieldName)) {
                    List<AdditionalLocation> additionalLocations
                        = reader.readArray(reader1 -> AdditionalLocation.fromJson(reader1));
                    deserializedApiManagementServiceBaseProperties.additionalLocations = additionalLocations;
                } else if ("customProperties".equals(fieldName)) {
                    Map<String, String> customProperties = reader.readMap(reader1 -> reader1.getString());
                    deserializedApiManagementServiceBaseProperties.customProperties = customProperties;
                } else if ("certificates".equals(fieldName)) {
                    List<CertificateConfiguration> certificates
                        = reader.readArray(reader1 -> CertificateConfiguration.fromJson(reader1));
                    deserializedApiManagementServiceBaseProperties.certificates = certificates;
                } else if ("enableClientCertificate".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.enableClientCertificate
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("natGatewayState".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.natGatewayState
                        = NatGatewayState.fromString(reader.getString());
                } else if ("outboundPublicIPAddresses".equals(fieldName)) {
                    List<String> outboundPublicIpAddresses = reader.readArray(reader1 -> reader1.getString());
                    deserializedApiManagementServiceBaseProperties.outboundPublicIpAddresses
                        = outboundPublicIpAddresses;
                } else if ("disableGateway".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.disableGateway
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("virtualNetworkType".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.virtualNetworkType
                        = VirtualNetworkType.fromString(reader.getString());
                } else if ("apiVersionConstraint".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.apiVersionConstraint
                        = ApiVersionConstraint.fromJson(reader);
                } else if ("restore".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.restore = reader.getNullable(JsonReader::getBoolean);
                } else if ("privateEndpointConnections".equals(fieldName)) {
                    List<RemotePrivateEndpointConnectionWrapper> privateEndpointConnections
                        = reader.readArray(reader1 -> RemotePrivateEndpointConnectionWrapper.fromJson(reader1));
                    deserializedApiManagementServiceBaseProperties.privateEndpointConnections
                        = privateEndpointConnections;
                } else if ("platformVersion".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.platformVersion
                        = PlatformVersion.fromString(reader.getString());
                } else if ("legacyPortalStatus".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.legacyPortalStatus
                        = LegacyPortalStatus.fromString(reader.getString());
                } else if ("developerPortalStatus".equals(fieldName)) {
                    deserializedApiManagementServiceBaseProperties.developerPortalStatus
                        = DeveloperPortalStatus.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementServiceBaseProperties;
        });
    }
}
