// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

/**
 * Identity properties of the Api Management service resource.
 */
@Fluent
public final class ApiManagementServiceIdentity implements JsonSerializable<ApiManagementServiceIdentity> {
    /*
     * The type of identity used for the resource. The type 'SystemAssigned, UserAssigned' includes both an implicitly
     * created identity and a set of user assigned identities. The type 'None' will remove any identities from the
     * service.
     */
    private ApimIdentityType type;

    /*
     * The principal id of the identity.
     */
    private UUID principalId;

    /*
     * The client tenant id of the identity.
     */
    private UUID tenantId;

    /*
     * The list of user identities associated with the resource. The user identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     * providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     */
    private Map<String, UserIdentityProperties> userAssignedIdentities;

    /**
     * Creates an instance of ApiManagementServiceIdentity class.
     */
    public ApiManagementServiceIdentity() {
    }

    /**
     * Get the type property: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned'
     * includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove
     * any identities from the service.
     * 
     * @return the type value.
     */
    public ApimIdentityType type() {
        return this.type;
    }

    /**
     * Set the type property: The type of identity used for the resource. The type 'SystemAssigned, UserAssigned'
     * includes both an implicitly created identity and a set of user assigned identities. The type 'None' will remove
     * any identities from the service.
     * 
     * @param type the type value to set.
     * @return the ApiManagementServiceIdentity object itself.
     */
    public ApiManagementServiceIdentity withType(ApimIdentityType type) {
        this.type = type;
        return this;
    }

    /**
     * Get the principalId property: The principal id of the identity.
     * 
     * @return the principalId value.
     */
    public UUID principalId() {
        return this.principalId;
    }

    /**
     * Get the tenantId property: The client tenant id of the identity.
     * 
     * @return the tenantId value.
     */
    public UUID tenantId() {
        return this.tenantId;
    }

    /**
     * Get the userAssignedIdentities property: The list of user identities associated with the resource. The user
     * identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     * providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * 
     * @return the userAssignedIdentities value.
     */
    public Map<String, UserIdentityProperties> userAssignedIdentities() {
        return this.userAssignedIdentities;
    }

    /**
     * Set the userAssignedIdentities property: The list of user identities associated with the resource. The user
     * identity
     * dictionary key references will be ARM resource ids in the form:
     * '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/
     * providers/Microsoft.ManagedIdentity/userAssignedIdentities/{identityName}'.
     * 
     * @param userAssignedIdentities the userAssignedIdentities value to set.
     * @return the ApiManagementServiceIdentity object itself.
     */
    public ApiManagementServiceIdentity
        withUserAssignedIdentities(Map<String, UserIdentityProperties> userAssignedIdentities) {
        this.userAssignedIdentities = userAssignedIdentities;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (type() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property type in model ApiManagementServiceIdentity"));
        }
        if (userAssignedIdentities() != null) {
            userAssignedIdentities().values().forEach(e -> {
                if (e != null) {
                    e.validate();
                }
            });
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementServiceIdentity.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        jsonWriter.writeMapField("userAssignedIdentities", this.userAssignedIdentities,
            (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementServiceIdentity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementServiceIdentity if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiManagementServiceIdentity.
     */
    public static ApiManagementServiceIdentity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementServiceIdentity deserializedApiManagementServiceIdentity = new ApiManagementServiceIdentity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("type".equals(fieldName)) {
                    deserializedApiManagementServiceIdentity.type = ApimIdentityType.fromString(reader.getString());
                } else if ("principalId".equals(fieldName)) {
                    deserializedApiManagementServiceIdentity.principalId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("tenantId".equals(fieldName)) {
                    deserializedApiManagementServiceIdentity.tenantId
                        = reader.getNullable(nonNullReader -> UUID.fromString(nonNullReader.getString()));
                } else if ("userAssignedIdentities".equals(fieldName)) {
                    Map<String, UserIdentityProperties> userAssignedIdentities
                        = reader.readMap(reader1 -> UserIdentityProperties.fromJson(reader1));
                    deserializedApiManagementServiceIdentity.userAssignedIdentities = userAssignedIdentities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementServiceIdentity;
        });
    }
}
