// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;

/**
 * Resource collection API of ApiManagementServices.
 */
public interface ApiManagementServices {
    /**
     * Restores a backup of an API Management service created using the ApiManagementService_Backup operation on the
     * current service. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param parameters Parameters supplied to the Restore API Management service from backup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management service resource in List or Get response.
     */
    ApiManagementServiceResource restore(String resourceGroupName, String serviceName,
        ApiManagementServiceBackupRestoreParameters parameters);

    /**
     * Restores a backup of an API Management service created using the ApiManagementService_Backup operation on the
     * current service. This is a long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param parameters Parameters supplied to the Restore API Management service from backup operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management service resource in List or Get response.
     */
    ApiManagementServiceResource restore(String resourceGroupName, String serviceName,
        ApiManagementServiceBackupRestoreParameters parameters, Context context);

    /**
     * Creates a backup of the API Management service to the given Azure Storage Account. This is long running operation
     * and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param parameters Parameters supplied to the ApiManagementService_Backup operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management service resource in List or Get response.
     */
    ApiManagementServiceResource backup(String resourceGroupName, String serviceName,
        ApiManagementServiceBackupRestoreParameters parameters);

    /**
     * Creates a backup of the API Management service to the given Azure Storage Account. This is long running operation
     * and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param parameters Parameters supplied to the ApiManagementService_Backup operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management service resource in List or Get response.
     */
    ApiManagementServiceResource backup(String resourceGroupName, String serviceName,
        ApiManagementServiceBackupRestoreParameters parameters, Context context);

    /**
     * Gets an API Management service resource description.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management service resource description along with {@link Response}.
     */
    Response<ApiManagementServiceResource> getByResourceGroupWithResponse(String resourceGroupName, String serviceName,
        Context context);

    /**
     * Gets an API Management service resource description.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management service resource description.
     */
    ApiManagementServiceResource getByResourceGroup(String resourceGroupName, String serviceName);

    /**
     * Deletes an existing API Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    ApiManagementServiceResource deleteByResourceGroup(String resourceGroupName, String serviceName);

    /**
     * Deletes an existing API Management service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    ApiManagementServiceResource delete(String resourceGroupName, String serviceName, Context context);

    /**
     * Upgrades an API Management service to the Stv2 platform. For details refer to https://aka.ms/apim-migrate-stv2.
     * This change is not reversible. This is long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management service resource in List or Get response.
     */
    ApiManagementServiceResource migrateToStv2(String resourceGroupName, String serviceName);

    /**
     * Upgrades an API Management service to the Stv2 platform. For details refer to https://aka.ms/apim-migrate-stv2.
     * This change is not reversible. This is long running operation and could take several minutes to complete.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param parameters Optional parameters supplied to migrate service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management service resource in List or Get response.
     */
    ApiManagementServiceResource migrateToStv2(String resourceGroupName, String serviceName,
        MigrateToStv2Contract parameters, Context context);

    /**
     * List all API Management services within a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management services operation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<ApiManagementServiceResource> listByResourceGroup(String resourceGroupName);

    /**
     * List all API Management services within a resource group.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management services operation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<ApiManagementServiceResource> listByResourceGroup(String resourceGroupName, Context context);

    /**
     * Lists all API Management services within an Azure subscription.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management services operation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<ApiManagementServiceResource> list();

    /**
     * Lists all API Management services within an Azure subscription.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management services operation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<ApiManagementServiceResource> list(Context context);

    /**
     * Gets the Single-Sign-On token for the API Management Service which is valid for 5 Minutes.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Single-Sign-On token for the API Management Service which is valid for 5 Minutes along with
     * {@link Response}.
     */
    Response<ApiManagementServiceGetSsoTokenResult> getSsoTokenWithResponse(String resourceGroupName,
        String serviceName, Context context);

    /**
     * Gets the Single-Sign-On token for the API Management Service which is valid for 5 Minutes.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the Single-Sign-On token for the API Management Service which is valid for 5 Minutes.
     */
    ApiManagementServiceGetSsoTokenResult getSsoToken(String resourceGroupName, String serviceName);

    /**
     * Checks availability and correctness of a name for an API Management service.
     * 
     * @param parameters Parameters supplied to the CheckNameAvailability operation.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response of the CheckNameAvailability operation along with {@link Response}.
     */
    Response<ApiManagementServiceNameAvailabilityResult> checkNameAvailabilityWithResponse(
        ApiManagementServiceCheckNameAvailabilityParameters parameters, Context context);

    /**
     * Checks availability and correctness of a name for an API Management service.
     * 
     * @param parameters Parameters supplied to the CheckNameAvailability operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return response of the CheckNameAvailability operation.
     */
    ApiManagementServiceNameAvailabilityResult
        checkNameAvailability(ApiManagementServiceCheckNameAvailabilityParameters parameters);

    /**
     * Get the custom domain ownership identifier for an API Management service.
     * 
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the custom domain ownership identifier for an API Management service along with {@link Response}.
     */
    Response<ApiManagementServiceGetDomainOwnershipIdentifierResult>
        getDomainOwnershipIdentifierWithResponse(Context context);

    /**
     * Get the custom domain ownership identifier for an API Management service.
     * 
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the custom domain ownership identifier for an API Management service.
     */
    ApiManagementServiceGetDomainOwnershipIdentifierResult getDomainOwnershipIdentifier();

    /**
     * Updates the Microsoft.ApiManagement resource running in the Virtual network to pick the updated DNS changes.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management service resource in List or Get response.
     */
    ApiManagementServiceResource applyNetworkConfigurationUpdates(String resourceGroupName, String serviceName);

    /**
     * Updates the Microsoft.ApiManagement resource running in the Virtual network to pick the updated DNS changes.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param parameters Parameters supplied to the Apply Network Configuration operation. If the parameters are empty,
     * all the regions in which the Api Management service is deployed will be updated sequentially without incurring
     * downtime in the region.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return a single API Management service resource in List or Get response.
     */
    ApiManagementServiceResource applyNetworkConfigurationUpdates(String resourceGroupName, String serviceName,
        ApiManagementServiceApplyNetworkConfigurationParameters parameters, Context context);

    /**
     * Gets an API Management service resource description.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management service resource description along with {@link Response}.
     */
    ApiManagementServiceResource getById(String id);

    /**
     * Gets an API Management service resource description.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return an API Management service resource description along with {@link Response}.
     */
    Response<ApiManagementServiceResource> getByIdWithResponse(String id, Context context);

    /**
     * Deletes an existing API Management service.
     * 
     * @param id the resource ID.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    ApiManagementServiceResource deleteById(String id);

    /**
     * Deletes an existing API Management service.
     * 
     * @param id the resource ID.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    ApiManagementServiceResource deleteByIdWithResponse(String id, Context context);

    /**
     * Begins definition for a new ApiManagementServiceResource resource.
     * 
     * @param name resource name.
     * @return the first stage of the new ApiManagementServiceResource definition.
     */
    ApiManagementServiceResource.DefinitionStages.Blank define(String name);
}
