// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes The SKU capabilities object.
 */
@Immutable
public final class ApiManagementSkuCapabilities implements JsonSerializable<ApiManagementSkuCapabilities> {
    /*
     * An invariant to describe the feature.
     */
    private String name;

    /*
     * An invariant if the feature is measured by quantity.
     */
    private String value;

    /**
     * Creates an instance of ApiManagementSkuCapabilities class.
     */
    public ApiManagementSkuCapabilities() {
    }

    /**
     * Get the name property: An invariant to describe the feature.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Get the value property: An invariant if the feature is measured by quantity.
     * 
     * @return the value value.
     */
    public String value() {
        return this.value;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementSkuCapabilities from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementSkuCapabilities if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementSkuCapabilities.
     */
    public static ApiManagementSkuCapabilities fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementSkuCapabilities deserializedApiManagementSkuCapabilities = new ApiManagementSkuCapabilities();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    deserializedApiManagementSkuCapabilities.name = reader.getString();
                } else if ("value".equals(fieldName)) {
                    deserializedApiManagementSkuCapabilities.value = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementSkuCapabilities;
        });
    }
}
