// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Describes scaling information of a SKU.
 */
@Immutable
public final class ApiManagementSkuCapacity implements JsonSerializable<ApiManagementSkuCapacity> {
    /*
     * The minimum capacity.
     */
    private Integer minimum;

    /*
     * The maximum capacity that can be set.
     */
    private Integer maximum;

    /*
     * The default capacity.
     */
    private Integer defaultProperty;

    /*
     * The scale type applicable to the sku.
     */
    private ApiManagementSkuCapacityScaleType scaleType;

    /**
     * Creates an instance of ApiManagementSkuCapacity class.
     */
    public ApiManagementSkuCapacity() {
    }

    /**
     * Get the minimum property: The minimum capacity.
     * 
     * @return the minimum value.
     */
    public Integer minimum() {
        return this.minimum;
    }

    /**
     * Get the maximum property: The maximum capacity that can be set.
     * 
     * @return the maximum value.
     */
    public Integer maximum() {
        return this.maximum;
    }

    /**
     * Get the defaultProperty property: The default capacity.
     * 
     * @return the defaultProperty value.
     */
    public Integer defaultProperty() {
        return this.defaultProperty;
    }

    /**
     * Get the scaleType property: The scale type applicable to the sku.
     * 
     * @return the scaleType value.
     */
    public ApiManagementSkuCapacityScaleType scaleType() {
        return this.scaleType;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementSkuCapacity from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementSkuCapacity if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementSkuCapacity.
     */
    public static ApiManagementSkuCapacity fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementSkuCapacity deserializedApiManagementSkuCapacity = new ApiManagementSkuCapacity();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minimum".equals(fieldName)) {
                    deserializedApiManagementSkuCapacity.minimum = reader.getNullable(JsonReader::getInt);
                } else if ("maximum".equals(fieldName)) {
                    deserializedApiManagementSkuCapacity.maximum = reader.getNullable(JsonReader::getInt);
                } else if ("default".equals(fieldName)) {
                    deserializedApiManagementSkuCapacity.defaultProperty = reader.getNullable(JsonReader::getInt);
                } else if ("scaleType".equals(fieldName)) {
                    deserializedApiManagementSkuCapacity.scaleType
                        = ApiManagementSkuCapacityScaleType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementSkuCapacity;
        });
    }
}
