// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The ApiManagementSkuLocationInfo model.
 */
@Immutable
public final class ApiManagementSkuLocationInfo implements JsonSerializable<ApiManagementSkuLocationInfo> {
    /*
     * Location of the SKU
     */
    private String location;

    /*
     * List of availability zones where the SKU is supported.
     */
    private List<String> zones;

    /*
     * Details of capabilities available to a SKU in specific zones.
     */
    private List<ApiManagementSkuZoneDetails> zoneDetails;

    /**
     * Creates an instance of ApiManagementSkuLocationInfo class.
     */
    public ApiManagementSkuLocationInfo() {
    }

    /**
     * Get the location property: Location of the SKU.
     * 
     * @return the location value.
     */
    public String location() {
        return this.location;
    }

    /**
     * Get the zones property: List of availability zones where the SKU is supported.
     * 
     * @return the zones value.
     */
    public List<String> zones() {
        return this.zones;
    }

    /**
     * Get the zoneDetails property: Details of capabilities available to a SKU in specific zones.
     * 
     * @return the zoneDetails value.
     */
    public List<ApiManagementSkuZoneDetails> zoneDetails() {
        return this.zoneDetails;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (zoneDetails() != null) {
            zoneDetails().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementSkuLocationInfo from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementSkuLocationInfo if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementSkuLocationInfo.
     */
    public static ApiManagementSkuLocationInfo fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementSkuLocationInfo deserializedApiManagementSkuLocationInfo = new ApiManagementSkuLocationInfo();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("location".equals(fieldName)) {
                    deserializedApiManagementSkuLocationInfo.location = reader.getString();
                } else if ("zones".equals(fieldName)) {
                    List<String> zones = reader.readArray(reader1 -> reader1.getString());
                    deserializedApiManagementSkuLocationInfo.zones = zones;
                } else if ("zoneDetails".equals(fieldName)) {
                    List<ApiManagementSkuZoneDetails> zoneDetails
                        = reader.readArray(reader1 -> ApiManagementSkuZoneDetails.fromJson(reader1));
                    deserializedApiManagementSkuLocationInfo.zoneDetails = zoneDetails;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementSkuLocationInfo;
        });
    }
}
