// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

/**
 * The reason for restriction.
 */
public enum ApiManagementSkuRestrictionsReasonCode {
    /**
     * Enum value QuotaId.
     */
    QUOTA_ID("QuotaId"),

    /**
     * Enum value NotAvailableForSubscription.
     */
    NOT_AVAILABLE_FOR_SUBSCRIPTION("NotAvailableForSubscription");

    /**
     * The actual serialized value for a ApiManagementSkuRestrictionsReasonCode instance.
     */
    private final String value;

    ApiManagementSkuRestrictionsReasonCode(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a ApiManagementSkuRestrictionsReasonCode instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed ApiManagementSkuRestrictionsReasonCode object, or null if unable to parse.
     */
    public static ApiManagementSkuRestrictionsReasonCode fromString(String value) {
        if (value == null) {
            return null;
        }
        ApiManagementSkuRestrictionsReasonCode[] items = ApiManagementSkuRestrictionsReasonCode.values();
        for (ApiManagementSkuRestrictionsReasonCode item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
