// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Immutable;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * Describes The zonal capabilities of a SKU.
 */
@Immutable
public final class ApiManagementSkuZoneDetails implements JsonSerializable<ApiManagementSkuZoneDetails> {
    /*
     * The set of zones that the SKU is available in with the specified capabilities.
     */
    private List<String> name;

    /*
     * A list of capabilities that are available for the SKU in the specified list of zones.
     */
    private List<ApiManagementSkuCapabilities> capabilities;

    /**
     * Creates an instance of ApiManagementSkuZoneDetails class.
     */
    public ApiManagementSkuZoneDetails() {
    }

    /**
     * Get the name property: The set of zones that the SKU is available in with the specified capabilities.
     * 
     * @return the name value.
     */
    public List<String> name() {
        return this.name;
    }

    /**
     * Get the capabilities property: A list of capabilities that are available for the SKU in the specified list of
     * zones.
     * 
     * @return the capabilities value.
     */
    public List<ApiManagementSkuCapabilities> capabilities() {
        return this.capabilities;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (capabilities() != null) {
            capabilities().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementSkuZoneDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementSkuZoneDetails if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiManagementSkuZoneDetails.
     */
    public static ApiManagementSkuZoneDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementSkuZoneDetails deserializedApiManagementSkuZoneDetails = new ApiManagementSkuZoneDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("name".equals(fieldName)) {
                    List<String> name = reader.readArray(reader1 -> reader1.getString());
                    deserializedApiManagementSkuZoneDetails.name = name;
                } else if ("capabilities".equals(fieldName)) {
                    List<ApiManagementSkuCapabilities> capabilities
                        = reader.readArray(reader1 -> ApiManagementSkuCapabilities.fromJson(reader1));
                    deserializedApiManagementSkuZoneDetails.capabilities = capabilities;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementSkuZoneDetails;
        });
    }
}
