// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.http.rest.PagedIterable;
import com.azure.core.util.Context;

/**
 * Resource collection API of ApiManagementWorkspaceLinks.
 */
public interface ApiManagementWorkspaceLinks {
    /**
     * List all API Management workspaceLinks for a service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management WorkspaceLink operation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<ApiManagementWorkspaceLinksResource> listByService(String resourceGroupName, String serviceName);

    /**
     * List all API Management workspaceLinks for a service.
     * 
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param serviceName The name of the API Management service.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response of the List API Management WorkspaceLink operation as paginated response with
     * {@link PagedIterable}.
     */
    PagedIterable<ApiManagementWorkspaceLinksResource> listByService(String resourceGroupName, String serviceName,
        Context context);
}
