// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.ApiManagementWorkspaceLinksResourceInner;
import java.io.IOException;
import java.util.List;

/**
 * The response of the List API Management WorkspaceLink operation.
 */
@Fluent
public final class ApiManagementWorkspaceLinksListResult
    implements JsonSerializable<ApiManagementWorkspaceLinksListResult> {
    /*
     * Result of the List API Management WorkspaceLinks operation.
     */
    private List<ApiManagementWorkspaceLinksResourceInner> value;

    /*
     * Link to the next set of results. Not empty if Value contains incomplete list of API Management services.
     */
    private String nextLink;

    /**
     * Creates an instance of ApiManagementWorkspaceLinksListResult class.
     */
    public ApiManagementWorkspaceLinksListResult() {
    }

    /**
     * Get the value property: Result of the List API Management WorkspaceLinks operation.
     * 
     * @return the value value.
     */
    public List<ApiManagementWorkspaceLinksResourceInner> value() {
        return this.value;
    }

    /**
     * Set the value property: Result of the List API Management WorkspaceLinks operation.
     * 
     * @param value the value value to set.
     * @return the ApiManagementWorkspaceLinksListResult object itself.
     */
    public ApiManagementWorkspaceLinksListResult withValue(List<ApiManagementWorkspaceLinksResourceInner> value) {
        this.value = value;
        return this;
    }

    /**
     * Get the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of API
     * Management services.
     * 
     * @return the nextLink value.
     */
    public String nextLink() {
        return this.nextLink;
    }

    /**
     * Set the nextLink property: Link to the next set of results. Not empty if Value contains incomplete list of API
     * Management services.
     * 
     * @param nextLink the nextLink value to set.
     * @return the ApiManagementWorkspaceLinksListResult object itself.
     */
    public ApiManagementWorkspaceLinksListResult withNextLink(String nextLink) {
        this.nextLink = nextLink;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (value() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property value in model ApiManagementWorkspaceLinksListResult"));
        } else {
            value().forEach(e -> e.validate());
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(ApiManagementWorkspaceLinksListResult.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("value", this.value, (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("nextLink", this.nextLink);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiManagementWorkspaceLinksListResult from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiManagementWorkspaceLinksListResult if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the ApiManagementWorkspaceLinksListResult.
     */
    public static ApiManagementWorkspaceLinksListResult fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiManagementWorkspaceLinksListResult deserializedApiManagementWorkspaceLinksListResult
                = new ApiManagementWorkspaceLinksListResult();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("value".equals(fieldName)) {
                    List<ApiManagementWorkspaceLinksResourceInner> value
                        = reader.readArray(reader1 -> ApiManagementWorkspaceLinksResourceInner.fromJson(reader1));
                    deserializedApiManagementWorkspaceLinksListResult.value = value;
                } else if ("nextLink".equals(fieldName)) {
                    deserializedApiManagementWorkspaceLinksListResult.nextLink = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiManagementWorkspaceLinksListResult;
        });
    }
}
