// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.resourcemanager.apimanagement.fluent.models.ApiRevisionContractInner;
import java.time.OffsetDateTime;

/**
 * An immutable client-side representation of ApiRevisionContract.
 */
public interface ApiRevisionContract {
    /**
     * Gets the apiId property: Identifier of the API Revision.
     * 
     * @return the apiId value.
     */
    String apiId();

    /**
     * Gets the apiRevision property: Revision number of API.
     * 
     * @return the apiRevision value.
     */
    String apiRevision();

    /**
     * Gets the createdDateTime property: The time the API Revision was created. The date conforms to the following
     * format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @return the createdDateTime value.
     */
    OffsetDateTime createdDateTime();

    /**
     * Gets the updatedDateTime property: The time the API Revision were updated. The date conforms to the following
     * format: yyyy-MM-ddTHH:mm:ssZ as specified by the ISO 8601 standard.
     * 
     * @return the updatedDateTime value.
     */
    OffsetDateTime updatedDateTime();

    /**
     * Gets the description property: Description of the API Revision.
     * 
     * @return the description value.
     */
    String description();

    /**
     * Gets the privateUrl property: Gateway URL for accessing the non-current API Revision.
     * 
     * @return the privateUrl value.
     */
    String privateUrl();

    /**
     * Gets the isOnline property: Indicates if API revision is the current api revision.
     * 
     * @return the isOnline value.
     */
    Boolean isOnline();

    /**
     * Gets the isCurrent property: Indicates if API revision is accessible via the gateway.
     * 
     * @return the isCurrent value.
     */
    Boolean isCurrent();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.ApiRevisionContractInner object.
     * 
     * @return the inner object.
     */
    ApiRevisionContractInner innerModel();
}
