// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Type of API.
 */
public final class ApiType extends ExpandableStringEnum<ApiType> {
    /**
     * Static value http for ApiType.
     */
    public static final ApiType HTTP = fromString("http");

    /**
     * Static value soap for ApiType.
     */
    public static final ApiType SOAP = fromString("soap");

    /**
     * Static value websocket for ApiType.
     */
    public static final ApiType WEBSOCKET = fromString("websocket");

    /**
     * Static value graphql for ApiType.
     */
    public static final ApiType GRAPHQL = fromString("graphql");

    /**
     * Static value odata for ApiType.
     */
    public static final ApiType ODATA = fromString("odata");

    /**
     * Static value grpc for ApiType.
     */
    public static final ApiType GRPC = fromString("grpc");

    /**
     * Creates a new instance of ApiType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public ApiType() {
    }

    /**
     * Creates or finds a ApiType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding ApiType.
     */
    public static ApiType fromString(String name) {
        return fromString(name, ApiType.class);
    }

    /**
     * Gets known ApiType values.
     * 
     * @return known ApiType values.
     */
    public static Collection<ApiType> values() {
        return values(ApiType.class);
    }
}
