// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Control Plane Apis version constraint for the API Management service.
 */
@Fluent
public final class ApiVersionConstraint implements JsonSerializable<ApiVersionConstraint> {
    /*
     * Limit control plane API calls to API Management service with version equal to or newer than this value.
     */
    private String minApiVersion;

    /**
     * Creates an instance of ApiVersionConstraint class.
     */
    public ApiVersionConstraint() {
    }

    /**
     * Get the minApiVersion property: Limit control plane API calls to API Management service with version equal to or
     * newer than this value.
     * 
     * @return the minApiVersion value.
     */
    public String minApiVersion() {
        return this.minApiVersion;
    }

    /**
     * Set the minApiVersion property: Limit control plane API calls to API Management service with version equal to or
     * newer than this value.
     * 
     * @param minApiVersion the minApiVersion value to set.
     * @return the ApiVersionConstraint object itself.
     */
    public ApiVersionConstraint withMinApiVersion(String minApiVersion) {
        this.minApiVersion = minApiVersion;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("minApiVersion", this.minApiVersion);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiVersionConstraint from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiVersionConstraint if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiVersionConstraint.
     */
    public static ApiVersionConstraint fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiVersionConstraint deserializedApiVersionConstraint = new ApiVersionConstraint();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("minApiVersion".equals(fieldName)) {
                    deserializedApiVersionConstraint.minApiVersion = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiVersionConstraint;
        });
    }
}
