// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * An API Version Set contains the common configuration for a set of API Versions relating.
 */
@Fluent
public final class ApiVersionSetContractDetails implements JsonSerializable<ApiVersionSetContractDetails> {
    /*
     * Identifier for existing API Version Set. Omit this value to create a new Version Set.
     */
    private String id;

    /*
     * The display Name of the API Version Set.
     */
    private String name;

    /*
     * Description of API Version Set.
     */
    private String description;

    /*
     * An value that determines where the API Version identifier will be located in a HTTP request.
     */
    private VersioningScheme versioningScheme;

    /*
     * Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
     */
    private String versionQueryName;

    /*
     * Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
     */
    private String versionHeaderName;

    /**
     * Creates an instance of ApiVersionSetContractDetails class.
     */
    public ApiVersionSetContractDetails() {
    }

    /**
     * Get the id property: Identifier for existing API Version Set. Omit this value to create a new Version Set.
     * 
     * @return the id value.
     */
    public String id() {
        return this.id;
    }

    /**
     * Set the id property: Identifier for existing API Version Set. Omit this value to create a new Version Set.
     * 
     * @param id the id value to set.
     * @return the ApiVersionSetContractDetails object itself.
     */
    public ApiVersionSetContractDetails withId(String id) {
        this.id = id;
        return this;
    }

    /**
     * Get the name property: The display Name of the API Version Set.
     * 
     * @return the name value.
     */
    public String name() {
        return this.name;
    }

    /**
     * Set the name property: The display Name of the API Version Set.
     * 
     * @param name the name value to set.
     * @return the ApiVersionSetContractDetails object itself.
     */
    public ApiVersionSetContractDetails withName(String name) {
        this.name = name;
        return this;
    }

    /**
     * Get the description property: Description of API Version Set.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of API Version Set.
     * 
     * @param description the description value to set.
     * @return the ApiVersionSetContractDetails object itself.
     */
    public ApiVersionSetContractDetails withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the versioningScheme property: An value that determines where the API Version identifier will be located in a
     * HTTP request.
     * 
     * @return the versioningScheme value.
     */
    public VersioningScheme versioningScheme() {
        return this.versioningScheme;
    }

    /**
     * Set the versioningScheme property: An value that determines where the API Version identifier will be located in a
     * HTTP request.
     * 
     * @param versioningScheme the versioningScheme value to set.
     * @return the ApiVersionSetContractDetails object itself.
     */
    public ApiVersionSetContractDetails withVersioningScheme(VersioningScheme versioningScheme) {
        this.versioningScheme = versioningScheme;
        return this;
    }

    /**
     * Get the versionQueryName property: Name of query parameter that indicates the API Version if versioningScheme is
     * set to `query`.
     * 
     * @return the versionQueryName value.
     */
    public String versionQueryName() {
        return this.versionQueryName;
    }

    /**
     * Set the versionQueryName property: Name of query parameter that indicates the API Version if versioningScheme is
     * set to `query`.
     * 
     * @param versionQueryName the versionQueryName value to set.
     * @return the ApiVersionSetContractDetails object itself.
     */
    public ApiVersionSetContractDetails withVersionQueryName(String versionQueryName) {
        this.versionQueryName = versionQueryName;
        return this;
    }

    /**
     * Get the versionHeaderName property: Name of HTTP header parameter that indicates the API Version if
     * versioningScheme is set to `header`.
     * 
     * @return the versionHeaderName value.
     */
    public String versionHeaderName() {
        return this.versionHeaderName;
    }

    /**
     * Set the versionHeaderName property: Name of HTTP header parameter that indicates the API Version if
     * versioningScheme is set to `header`.
     * 
     * @param versionHeaderName the versionHeaderName value to set.
     * @return the ApiVersionSetContractDetails object itself.
     */
    public ApiVersionSetContractDetails withVersionHeaderName(String versionHeaderName) {
        this.versionHeaderName = versionHeaderName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("versioningScheme",
            this.versioningScheme == null ? null : this.versioningScheme.toString());
        jsonWriter.writeStringField("versionQueryName", this.versionQueryName);
        jsonWriter.writeStringField("versionHeaderName", this.versionHeaderName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiVersionSetContractDetails from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiVersionSetContractDetails if the JsonReader was pointing to an instance of it, or null
     * if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiVersionSetContractDetails.
     */
    public static ApiVersionSetContractDetails fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiVersionSetContractDetails deserializedApiVersionSetContractDetails = new ApiVersionSetContractDetails();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedApiVersionSetContractDetails.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedApiVersionSetContractDetails.name = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedApiVersionSetContractDetails.description = reader.getString();
                } else if ("versioningScheme".equals(fieldName)) {
                    deserializedApiVersionSetContractDetails.versioningScheme
                        = VersioningScheme.fromString(reader.getString());
                } else if ("versionQueryName".equals(fieldName)) {
                    deserializedApiVersionSetContractDetails.versionQueryName = reader.getString();
                } else if ("versionHeaderName".equals(fieldName)) {
                    deserializedApiVersionSetContractDetails.versionHeaderName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiVersionSetContractDetails;
        });
    }
}
