// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * API Version set base parameters.
 */
@Fluent
public class ApiVersionSetEntityBase implements JsonSerializable<ApiVersionSetEntityBase> {
    /*
     * Description of API Version Set.
     */
    private String description;

    /*
     * Name of query parameter that indicates the API Version if versioningScheme is set to `query`.
     */
    private String versionQueryName;

    /*
     * Name of HTTP header parameter that indicates the API Version if versioningScheme is set to `header`.
     */
    private String versionHeaderName;

    /**
     * Creates an instance of ApiVersionSetEntityBase class.
     */
    public ApiVersionSetEntityBase() {
    }

    /**
     * Get the description property: Description of API Version Set.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of API Version Set.
     * 
     * @param description the description value to set.
     * @return the ApiVersionSetEntityBase object itself.
     */
    public ApiVersionSetEntityBase withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the versionQueryName property: Name of query parameter that indicates the API Version if versioningScheme is
     * set to `query`.
     * 
     * @return the versionQueryName value.
     */
    public String versionQueryName() {
        return this.versionQueryName;
    }

    /**
     * Set the versionQueryName property: Name of query parameter that indicates the API Version if versioningScheme is
     * set to `query`.
     * 
     * @param versionQueryName the versionQueryName value to set.
     * @return the ApiVersionSetEntityBase object itself.
     */
    public ApiVersionSetEntityBase withVersionQueryName(String versionQueryName) {
        this.versionQueryName = versionQueryName;
        return this;
    }

    /**
     * Get the versionHeaderName property: Name of HTTP header parameter that indicates the API Version if
     * versioningScheme is set to `header`.
     * 
     * @return the versionHeaderName value.
     */
    public String versionHeaderName() {
        return this.versionHeaderName;
    }

    /**
     * Set the versionHeaderName property: Name of HTTP header parameter that indicates the API Version if
     * versioningScheme is set to `header`.
     * 
     * @param versionHeaderName the versionHeaderName value to set.
     * @return the ApiVersionSetEntityBase object itself.
     */
    public ApiVersionSetEntityBase withVersionHeaderName(String versionHeaderName) {
        this.versionHeaderName = versionHeaderName;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("versionQueryName", this.versionQueryName);
        jsonWriter.writeStringField("versionHeaderName", this.versionHeaderName);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of ApiVersionSetEntityBase from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of ApiVersionSetEntityBase if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the ApiVersionSetEntityBase.
     */
    public static ApiVersionSetEntityBase fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            ApiVersionSetEntityBase deserializedApiVersionSetEntityBase = new ApiVersionSetEntityBase();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedApiVersionSetEntityBase.description = reader.getString();
                } else if ("versionQueryName".equals(fieldName)) {
                    deserializedApiVersionSetEntityBase.versionQueryName = reader.getString();
                } else if ("versionHeaderName".equals(fieldName)) {
                    deserializedApiVersionSetEntityBase.versionHeaderName = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedApiVersionSetEntityBase;
        });
    }
}
