// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Defines values for AppType.
 */
public final class AppType extends ExpandableStringEnum<AppType> {
    /**
     * Static value portal for AppType.
     */
    public static final AppType PORTAL = fromString("portal");

    /**
     * Static value developerPortal for AppType.
     */
    public static final AppType DEVELOPER_PORTAL = fromString("developerPortal");

    /**
     * Creates a new instance of AppType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AppType() {
    }

    /**
     * Creates or finds a AppType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AppType.
     */
    public static AppType fromString(String name) {
        return fromString(name, AppType.class);
    }

    /**
     * Gets known AppType values.
     * 
     * @return known AppType values.
     */
    public static Collection<AppType> values() {
        return values(AppType.class);
    }
}
