// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.management.ProxyResource;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import com.azure.resourcemanager.apimanagement.fluent.models.AssociationContractProperties;
import java.io.IOException;

/**
 * Association entity details.
 */
@Fluent
public final class AssociationContract extends ProxyResource {
    /*
     * Association entity contract properties.
     */
    private AssociationContractProperties innerProperties;

    /*
     * The type of the resource.
     */
    private String type;

    /*
     * The name of the resource.
     */
    private String name;

    /*
     * Fully qualified resource Id for the resource.
     */
    private String id;

    /**
     * Creates an instance of AssociationContract class.
     */
    public AssociationContract() {
    }

    /**
     * Get the innerProperties property: Association entity contract properties.
     * 
     * @return the innerProperties value.
     */
    private AssociationContractProperties innerProperties() {
        return this.innerProperties;
    }

    /**
     * Get the type property: The type of the resource.
     * 
     * @return the type value.
     */
    @Override
    public String type() {
        return this.type;
    }

    /**
     * Get the name property: The name of the resource.
     * 
     * @return the name value.
     */
    @Override
    public String name() {
        return this.name;
    }

    /**
     * Get the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    @Override
    public String id() {
        return this.id;
    }

    /**
     * Get the provisioningState property: Provisioning state.
     * 
     * @return the provisioningState value.
     */
    public ProvisioningState provisioningState() {
        return this.innerProperties() == null ? null : this.innerProperties().provisioningState();
    }

    /**
     * Set the provisioningState property: Provisioning state.
     * 
     * @param provisioningState the provisioningState value to set.
     * @return the AssociationContract object itself.
     */
    public AssociationContract withProvisioningState(ProvisioningState provisioningState) {
        if (this.innerProperties() == null) {
            this.innerProperties = new AssociationContractProperties();
        }
        this.innerProperties().withProvisioningState(provisioningState);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (innerProperties() != null) {
            innerProperties().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("properties", this.innerProperties);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AssociationContract from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AssociationContract if the JsonReader was pointing to an instance of it, or null if it was
     * pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the AssociationContract.
     */
    public static AssociationContract fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AssociationContract deserializedAssociationContract = new AssociationContract();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("id".equals(fieldName)) {
                    deserializedAssociationContract.id = reader.getString();
                } else if ("name".equals(fieldName)) {
                    deserializedAssociationContract.name = reader.getString();
                } else if ("type".equals(fieldName)) {
                    deserializedAssociationContract.type = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedAssociationContract.innerProperties = AssociationContractProperties.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAssociationContract;
        });
    }
}
