// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

/**
 * Status of an async operation.
 */
public enum AsyncOperationStatus {
    /**
     * Enum value Started.
     */
    STARTED("Started"),

    /**
     * Enum value InProgress.
     */
    IN_PROGRESS("InProgress"),

    /**
     * Enum value Succeeded.
     */
    SUCCEEDED("Succeeded"),

    /**
     * Enum value Failed.
     */
    FAILED("Failed");

    /**
     * The actual serialized value for a AsyncOperationStatus instance.
     */
    private final String value;

    AsyncOperationStatus(String value) {
        this.value = value;
    }

    /**
     * Parses a serialized value to a AsyncOperationStatus instance.
     * 
     * @param value the serialized value to parse.
     * @return the parsed AsyncOperationStatus object, or null if unable to parse.
     */
    public static AsyncOperationStatus fromString(String value) {
        if (value == null) {
            return null;
        }
        AsyncOperationStatus[] items = AsyncOperationStatus.values();
        for (AsyncOperationStatus item : items) {
            if (item.toString().equalsIgnoreCase(value)) {
                return item;
            }
        }
        return null;
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public String toString() {
        return this.value;
    }
}
