// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationAccessPolicyContractInner;
import java.util.List;

/**
 * An immutable client-side representation of AuthorizationAccessPolicyContract.
 */
public interface AuthorizationAccessPolicyContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the appIds property: The allowed Azure Active Directory Application IDs.
     * 
     * @return the appIds value.
     */
    List<String> appIds();

    /**
     * Gets the tenantId property: The Tenant Id.
     * 
     * @return the tenantId value.
     */
    String tenantId();

    /**
     * Gets the objectId property: The Object Id.
     * 
     * @return the objectId value.
     */
    String objectId();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationAccessPolicyContractInner
     * object.
     * 
     * @return the inner object.
     */
    AuthorizationAccessPolicyContractInner innerModel();

    /**
     * The entirety of the AuthorizationAccessPolicyContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The AuthorizationAccessPolicyContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the AuthorizationAccessPolicyContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName, authorizationProviderId, authorizationId.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @param authorizationProviderId Identifier of the authorization provider.
             * @param authorizationId Identifier of the authorization.
             * @return the next definition stage.
             */
            WithCreate withExistingAuthorization(String resourceGroupName, String serviceName,
                String authorizationProviderId, String authorizationId);
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract definition which contains all the minimum required
         * properties for the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithAppIds, DefinitionStages.WithTenantId,
            DefinitionStages.WithObjectId, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            AuthorizationAccessPolicyContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            AuthorizationAccessPolicyContract create(Context context);
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract definition allowing to specify appIds.
         */
        interface WithAppIds {
            /**
             * Specifies the appIds property: The allowed Azure Active Directory Application IDs.
             * 
             * @param appIds The allowed Azure Active Directory Application IDs.
             * @return the next definition stage.
             */
            WithCreate withAppIds(List<String> appIds);
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract definition allowing to specify tenantId.
         */
        interface WithTenantId {
            /**
             * Specifies the tenantId property: The Tenant Id.
             * 
             * @param tenantId The Tenant Id.
             * @return the next definition stage.
             */
            WithCreate withTenantId(String tenantId);
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract definition allowing to specify objectId.
         */
        interface WithObjectId {
            /**
             * Specifies the objectId property: The Object Id.
             * 
             * @param objectId The Object Id.
             * @return the next definition stage.
             */
            WithCreate withObjectId(String objectId);
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the AuthorizationAccessPolicyContract resource.
     * 
     * @return the stage of resource update.
     */
    AuthorizationAccessPolicyContract.Update update();

    /**
     * The template for AuthorizationAccessPolicyContract update.
     */
    interface Update extends UpdateStages.WithAppIds, UpdateStages.WithTenantId, UpdateStages.WithObjectId,
        UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        AuthorizationAccessPolicyContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        AuthorizationAccessPolicyContract apply(Context context);
    }

    /**
     * The AuthorizationAccessPolicyContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the AuthorizationAccessPolicyContract update allowing to specify appIds.
         */
        interface WithAppIds {
            /**
             * Specifies the appIds property: The allowed Azure Active Directory Application IDs.
             * 
             * @param appIds The allowed Azure Active Directory Application IDs.
             * @return the next definition stage.
             */
            Update withAppIds(List<String> appIds);
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract update allowing to specify tenantId.
         */
        interface WithTenantId {
            /**
             * Specifies the tenantId property: The Tenant Id.
             * 
             * @param tenantId The Tenant Id.
             * @return the next definition stage.
             */
            Update withTenantId(String tenantId);
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract update allowing to specify objectId.
         */
        interface WithObjectId {
            /**
             * Specifies the objectId property: The Object Id.
             * 
             * @param objectId The Object Id.
             * @return the next definition stage.
             */
            Update withObjectId(String objectId);
        }

        /**
         * The stage of the AuthorizationAccessPolicyContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    AuthorizationAccessPolicyContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    AuthorizationAccessPolicyContract refresh(Context context);
}
