// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractInner;
import java.util.Map;

/**
 * An immutable client-side representation of AuthorizationContract.
 */
public interface AuthorizationContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the authorizationType property: Authorization type options.
     * 
     * @return the authorizationType value.
     */
    AuthorizationType authorizationType();

    /**
     * Gets the oAuth2GrantType property: OAuth2 grant type options.
     * 
     * @return the oAuth2GrantType value.
     */
    OAuth2GrantType oAuth2GrantType();

    /**
     * Gets the parameters property: Authorization parameters.
     * 
     * @return the parameters value.
     */
    Map<String, String> parameters();

    /**
     * Gets the error property: Authorization error details.
     * 
     * @return the error value.
     */
    AuthorizationError error();

    /**
     * Gets the status property: Status of the Authorization.
     * 
     * @return the status value.
     */
    String status();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationContractInner object.
     * 
     * @return the inner object.
     */
    AuthorizationContractInner innerModel();

    /**
     * The entirety of the AuthorizationContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The AuthorizationContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the AuthorizationContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the AuthorizationContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName, authorizationProviderId.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @param authorizationProviderId Identifier of the authorization provider.
             * @return the next definition stage.
             */
            WithCreate withExistingAuthorizationProvider(String resourceGroupName, String serviceName,
                String authorizationProviderId);
        }

        /**
         * The stage of the AuthorizationContract definition which contains all the minimum required properties for the
         * resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithAuthorizationType, DefinitionStages.WithOAuth2GrantType,
            DefinitionStages.WithParameters, DefinitionStages.WithError, DefinitionStages.WithStatus,
            DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            AuthorizationContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            AuthorizationContract create(Context context);
        }

        /**
         * The stage of the AuthorizationContract definition allowing to specify authorizationType.
         */
        interface WithAuthorizationType {
            /**
             * Specifies the authorizationType property: Authorization type options.
             * 
             * @param authorizationType Authorization type options.
             * @return the next definition stage.
             */
            WithCreate withAuthorizationType(AuthorizationType authorizationType);
        }

        /**
         * The stage of the AuthorizationContract definition allowing to specify oAuth2GrantType.
         */
        interface WithOAuth2GrantType {
            /**
             * Specifies the oAuth2GrantType property: OAuth2 grant type options.
             * 
             * @param oAuth2GrantType OAuth2 grant type options.
             * @return the next definition stage.
             */
            WithCreate withOAuth2GrantType(OAuth2GrantType oAuth2GrantType);
        }

        /**
         * The stage of the AuthorizationContract definition allowing to specify parameters.
         */
        interface WithParameters {
            /**
             * Specifies the parameters property: Authorization parameters.
             * 
             * @param parameters Authorization parameters.
             * @return the next definition stage.
             */
            WithCreate withParameters(Map<String, String> parameters);
        }

        /**
         * The stage of the AuthorizationContract definition allowing to specify error.
         */
        interface WithError {
            /**
             * Specifies the error property: Authorization error details..
             * 
             * @param error Authorization error details.
             * @return the next definition stage.
             */
            WithCreate withError(AuthorizationError error);
        }

        /**
         * The stage of the AuthorizationContract definition allowing to specify status.
         */
        interface WithStatus {
            /**
             * Specifies the status property: Status of the Authorization.
             * 
             * @param status Status of the Authorization.
             * @return the next definition stage.
             */
            WithCreate withStatus(String status);
        }

        /**
         * The stage of the AuthorizationContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the AuthorizationContract resource.
     * 
     * @return the stage of resource update.
     */
    AuthorizationContract.Update update();

    /**
     * The template for AuthorizationContract update.
     */
    interface Update extends UpdateStages.WithAuthorizationType, UpdateStages.WithOAuth2GrantType,
        UpdateStages.WithParameters, UpdateStages.WithError, UpdateStages.WithStatus, UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        AuthorizationContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        AuthorizationContract apply(Context context);
    }

    /**
     * The AuthorizationContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the AuthorizationContract update allowing to specify authorizationType.
         */
        interface WithAuthorizationType {
            /**
             * Specifies the authorizationType property: Authorization type options.
             * 
             * @param authorizationType Authorization type options.
             * @return the next definition stage.
             */
            Update withAuthorizationType(AuthorizationType authorizationType);
        }

        /**
         * The stage of the AuthorizationContract update allowing to specify oAuth2GrantType.
         */
        interface WithOAuth2GrantType {
            /**
             * Specifies the oAuth2GrantType property: OAuth2 grant type options.
             * 
             * @param oAuth2GrantType OAuth2 grant type options.
             * @return the next definition stage.
             */
            Update withOAuth2GrantType(OAuth2GrantType oAuth2GrantType);
        }

        /**
         * The stage of the AuthorizationContract update allowing to specify parameters.
         */
        interface WithParameters {
            /**
             * Specifies the parameters property: Authorization parameters.
             * 
             * @param parameters Authorization parameters.
             * @return the next definition stage.
             */
            Update withParameters(Map<String, String> parameters);
        }

        /**
         * The stage of the AuthorizationContract update allowing to specify error.
         */
        interface WithError {
            /**
             * Specifies the error property: Authorization error details..
             * 
             * @param error Authorization error details.
             * @return the next definition stage.
             */
            Update withError(AuthorizationError error);
        }

        /**
         * The stage of the AuthorizationContract update allowing to specify status.
         */
        interface WithStatus {
            /**
             * Specifies the status property: Status of the Authorization.
             * 
             * @param status Status of the Authorization.
             * @return the next definition stage.
             */
            Update withStatus(String status);
        }

        /**
         * The stage of the AuthorizationContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    AuthorizationContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    AuthorizationContract refresh(Context context);

    /**
     * Confirm valid consent code to suppress Authorizations anti-phishing page.
     * 
     * @param parameters Create parameters.
     * @param context The context to associate with this operation.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     * @return the response.
     */
    AuthorizationsConfirmConsentCodeResponse
        confirmConsentCodeWithResponse(AuthorizationConfirmConsentCodeRequestContract parameters, Context context);

    /**
     * Confirm valid consent code to suppress Authorizations anti-phishing page.
     * 
     * @param parameters Create parameters.
     * @throws IllegalArgumentException thrown if parameters fail the validation.
     * @throws com.azure.core.management.exception.ManagementException thrown if the request is rejected by server.
     * @throws RuntimeException all other wrapped checked exceptions if the request fails to be sent.
     */
    void confirmConsentCode(AuthorizationConfirmConsentCodeRequestContract parameters);
}
