// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.Context;
import com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationProviderContractInner;

/**
 * An immutable client-side representation of AuthorizationProviderContract.
 */
public interface AuthorizationProviderContract {
    /**
     * Gets the id property: Fully qualified resource Id for the resource.
     * 
     * @return the id value.
     */
    String id();

    /**
     * Gets the name property: The name of the resource.
     * 
     * @return the name value.
     */
    String name();

    /**
     * Gets the type property: The type of the resource.
     * 
     * @return the type value.
     */
    String type();

    /**
     * Gets the displayName property: Authorization Provider name. Must be 1 to 300 characters long.
     * 
     * @return the displayName value.
     */
    String displayName();

    /**
     * Gets the identityProvider property: Identity provider name. Must be 1 to 300 characters long.
     * 
     * @return the identityProvider value.
     */
    String identityProvider();

    /**
     * Gets the oauth2 property: OAuth2 settings.
     * 
     * @return the oauth2 value.
     */
    AuthorizationProviderOAuth2Settings oauth2();

    /**
     * Gets the name of the resource group.
     * 
     * @return the name of the resource group.
     */
    String resourceGroupName();

    /**
     * Gets the inner com.azure.resourcemanager.apimanagement.fluent.models.AuthorizationProviderContractInner object.
     * 
     * @return the inner object.
     */
    AuthorizationProviderContractInner innerModel();

    /**
     * The entirety of the AuthorizationProviderContract definition.
     */
    interface Definition
        extends DefinitionStages.Blank, DefinitionStages.WithParentResource, DefinitionStages.WithCreate {
    }

    /**
     * The AuthorizationProviderContract definition stages.
     */
    interface DefinitionStages {
        /**
         * The first stage of the AuthorizationProviderContract definition.
         */
        interface Blank extends WithParentResource {
        }

        /**
         * The stage of the AuthorizationProviderContract definition allowing to specify parent resource.
         */
        interface WithParentResource {
            /**
             * Specifies resourceGroupName, serviceName.
             * 
             * @param resourceGroupName The name of the resource group. The name is case insensitive.
             * @param serviceName The name of the API Management service.
             * @return the next definition stage.
             */
            WithCreate withExistingService(String resourceGroupName, String serviceName);
        }

        /**
         * The stage of the AuthorizationProviderContract definition which contains all the minimum required properties
         * for the resource to be created, but also allows for any other optional properties to be specified.
         */
        interface WithCreate extends DefinitionStages.WithDisplayName, DefinitionStages.WithIdentityProvider,
            DefinitionStages.WithOauth2, DefinitionStages.WithIfMatch {
            /**
             * Executes the create request.
             * 
             * @return the created resource.
             */
            AuthorizationProviderContract create();

            /**
             * Executes the create request.
             * 
             * @param context The context to associate with this operation.
             * @return the created resource.
             */
            AuthorizationProviderContract create(Context context);
        }

        /**
         * The stage of the AuthorizationProviderContract definition allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Authorization Provider name. Must be 1 to 300 characters long..
             * 
             * @param displayName Authorization Provider name. Must be 1 to 300 characters long.
             * @return the next definition stage.
             */
            WithCreate withDisplayName(String displayName);
        }

        /**
         * The stage of the AuthorizationProviderContract definition allowing to specify identityProvider.
         */
        interface WithIdentityProvider {
            /**
             * Specifies the identityProvider property: Identity provider name. Must be 1 to 300 characters long..
             * 
             * @param identityProvider Identity provider name. Must be 1 to 300 characters long.
             * @return the next definition stage.
             */
            WithCreate withIdentityProvider(String identityProvider);
        }

        /**
         * The stage of the AuthorizationProviderContract definition allowing to specify oauth2.
         */
        interface WithOauth2 {
            /**
             * Specifies the oauth2 property: OAuth2 settings.
             * 
             * @param oauth2 OAuth2 settings.
             * @return the next definition stage.
             */
            WithCreate withOauth2(AuthorizationProviderOAuth2Settings oauth2);
        }

        /**
         * The stage of the AuthorizationProviderContract definition allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            WithCreate withIfMatch(String ifMatch);
        }
    }

    /**
     * Begins update for the AuthorizationProviderContract resource.
     * 
     * @return the stage of resource update.
     */
    AuthorizationProviderContract.Update update();

    /**
     * The template for AuthorizationProviderContract update.
     */
    interface Update extends UpdateStages.WithDisplayName, UpdateStages.WithIdentityProvider, UpdateStages.WithOauth2,
        UpdateStages.WithIfMatch {
        /**
         * Executes the update request.
         * 
         * @return the updated resource.
         */
        AuthorizationProviderContract apply();

        /**
         * Executes the update request.
         * 
         * @param context The context to associate with this operation.
         * @return the updated resource.
         */
        AuthorizationProviderContract apply(Context context);
    }

    /**
     * The AuthorizationProviderContract update stages.
     */
    interface UpdateStages {
        /**
         * The stage of the AuthorizationProviderContract update allowing to specify displayName.
         */
        interface WithDisplayName {
            /**
             * Specifies the displayName property: Authorization Provider name. Must be 1 to 300 characters long..
             * 
             * @param displayName Authorization Provider name. Must be 1 to 300 characters long.
             * @return the next definition stage.
             */
            Update withDisplayName(String displayName);
        }

        /**
         * The stage of the AuthorizationProviderContract update allowing to specify identityProvider.
         */
        interface WithIdentityProvider {
            /**
             * Specifies the identityProvider property: Identity provider name. Must be 1 to 300 characters long..
             * 
             * @param identityProvider Identity provider name. Must be 1 to 300 characters long.
             * @return the next definition stage.
             */
            Update withIdentityProvider(String identityProvider);
        }

        /**
         * The stage of the AuthorizationProviderContract update allowing to specify oauth2.
         */
        interface WithOauth2 {
            /**
             * Specifies the oauth2 property: OAuth2 settings.
             * 
             * @param oauth2 OAuth2 settings.
             * @return the next definition stage.
             */
            Update withOauth2(AuthorizationProviderOAuth2Settings oauth2);
        }

        /**
         * The stage of the AuthorizationProviderContract update allowing to specify ifMatch.
         */
        interface WithIfMatch {
            /**
             * Specifies the ifMatch property: ETag of the Entity. Not required when creating an entity, but required
             * when updating an entity..
             * 
             * @param ifMatch ETag of the Entity. Not required when creating an entity, but required when updating an
             * entity.
             * @return the next definition stage.
             */
            Update withIfMatch(String ifMatch);
        }
    }

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @return the refreshed resource.
     */
    AuthorizationProviderContract refresh();

    /**
     * Refreshes the resource to sync with Azure.
     * 
     * @param context The context to associate with this operation.
     * @return the refreshed resource.
     */
    AuthorizationProviderContract refresh(Context context);
}
