// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * External OAuth authorization server Update settings contract.
 */
@Fluent
public class AuthorizationServerContractBaseProperties
    implements JsonSerializable<AuthorizationServerContractBaseProperties> {
    /*
     * Description of the authorization server. Can contain HTML formatting tags.
     */
    private String description;

    /*
     * HTTP verbs supported by the authorization endpoint. GET must be always present. POST is optional.
     */
    private List<AuthorizationMethod> authorizationMethods;

    /*
     * Method of authentication supported by the token endpoint of this authorization server. Possible values are Basic
     * and/or Body. When Body is specified, client credentials and other parameters are passed within the request body
     * in the application/x-www-form-urlencoded format.
     */
    private List<ClientAuthenticationMethod> clientAuthenticationMethod;

    /*
     * Additional parameters required by the token endpoint of this authorization server represented as an array of JSON
     * objects with name and value string properties, i.e. {"name" : "name value", "value": "a value"}.
     */
    private List<TokenBodyParameterContract> tokenBodyParameters;

    /*
     * OAuth token endpoint. Contains absolute URI to entity being referenced.
     */
    private String tokenEndpoint;

    /*
     * If true, authorization server will include state parameter from the authorization request to its response. Client
     * may use state parameter to raise protocol security.
     */
    private Boolean supportState;

    /*
     * Access token scope that is going to be requested by default. Can be overridden at the API level. Should be
     * provided in the form of a string containing space-delimited values.
     */
    private String defaultScope;

    /*
     * Specifies the mechanism by which access token is passed to the API.
     */
    private List<BearerTokenSendingMethod> bearerTokenSendingMethods;

    /*
     * Can be optionally specified when resource owner password grant type is supported by this authorization server.
     * Default resource owner username.
     */
    private String resourceOwnerUsername;

    /*
     * Can be optionally specified when resource owner password grant type is supported by this authorization server.
     * Default resource owner password.
     */
    private String resourceOwnerPassword;

    /**
     * Creates an instance of AuthorizationServerContractBaseProperties class.
     */
    public AuthorizationServerContractBaseProperties() {
    }

    /**
     * Get the description property: Description of the authorization server. Can contain HTML formatting tags.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Description of the authorization server. Can contain HTML formatting tags.
     * 
     * @param description the description value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the authorizationMethods property: HTTP verbs supported by the authorization endpoint. GET must be always
     * present. POST is optional.
     * 
     * @return the authorizationMethods value.
     */
    public List<AuthorizationMethod> authorizationMethods() {
        return this.authorizationMethods;
    }

    /**
     * Set the authorizationMethods property: HTTP verbs supported by the authorization endpoint. GET must be always
     * present. POST is optional.
     * 
     * @param authorizationMethods the authorizationMethods value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties
        withAuthorizationMethods(List<AuthorizationMethod> authorizationMethods) {
        this.authorizationMethods = authorizationMethods;
        return this;
    }

    /**
     * Get the clientAuthenticationMethod property: Method of authentication supported by the token endpoint of this
     * authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other
     * parameters are passed within the request body in the application/x-www-form-urlencoded format.
     * 
     * @return the clientAuthenticationMethod value.
     */
    public List<ClientAuthenticationMethod> clientAuthenticationMethod() {
        return this.clientAuthenticationMethod;
    }

    /**
     * Set the clientAuthenticationMethod property: Method of authentication supported by the token endpoint of this
     * authorization server. Possible values are Basic and/or Body. When Body is specified, client credentials and other
     * parameters are passed within the request body in the application/x-www-form-urlencoded format.
     * 
     * @param clientAuthenticationMethod the clientAuthenticationMethod value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties
        withClientAuthenticationMethod(List<ClientAuthenticationMethod> clientAuthenticationMethod) {
        this.clientAuthenticationMethod = clientAuthenticationMethod;
        return this;
    }

    /**
     * Get the tokenBodyParameters property: Additional parameters required by the token endpoint of this authorization
     * server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name
     * value", "value": "a value"}.
     * 
     * @return the tokenBodyParameters value.
     */
    public List<TokenBodyParameterContract> tokenBodyParameters() {
        return this.tokenBodyParameters;
    }

    /**
     * Set the tokenBodyParameters property: Additional parameters required by the token endpoint of this authorization
     * server represented as an array of JSON objects with name and value string properties, i.e. {"name" : "name
     * value", "value": "a value"}.
     * 
     * @param tokenBodyParameters the tokenBodyParameters value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties
        withTokenBodyParameters(List<TokenBodyParameterContract> tokenBodyParameters) {
        this.tokenBodyParameters = tokenBodyParameters;
        return this;
    }

    /**
     * Get the tokenEndpoint property: OAuth token endpoint. Contains absolute URI to entity being referenced.
     * 
     * @return the tokenEndpoint value.
     */
    public String tokenEndpoint() {
        return this.tokenEndpoint;
    }

    /**
     * Set the tokenEndpoint property: OAuth token endpoint. Contains absolute URI to entity being referenced.
     * 
     * @param tokenEndpoint the tokenEndpoint value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties withTokenEndpoint(String tokenEndpoint) {
        this.tokenEndpoint = tokenEndpoint;
        return this;
    }

    /**
     * Get the supportState property: If true, authorization server will include state parameter from the authorization
     * request to its response. Client may use state parameter to raise protocol security.
     * 
     * @return the supportState value.
     */
    public Boolean supportState() {
        return this.supportState;
    }

    /**
     * Set the supportState property: If true, authorization server will include state parameter from the authorization
     * request to its response. Client may use state parameter to raise protocol security.
     * 
     * @param supportState the supportState value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties withSupportState(Boolean supportState) {
        this.supportState = supportState;
        return this;
    }

    /**
     * Get the defaultScope property: Access token scope that is going to be requested by default. Can be overridden at
     * the API level. Should be provided in the form of a string containing space-delimited values.
     * 
     * @return the defaultScope value.
     */
    public String defaultScope() {
        return this.defaultScope;
    }

    /**
     * Set the defaultScope property: Access token scope that is going to be requested by default. Can be overridden at
     * the API level. Should be provided in the form of a string containing space-delimited values.
     * 
     * @param defaultScope the defaultScope value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties withDefaultScope(String defaultScope) {
        this.defaultScope = defaultScope;
        return this;
    }

    /**
     * Get the bearerTokenSendingMethods property: Specifies the mechanism by which access token is passed to the API.
     * 
     * @return the bearerTokenSendingMethods value.
     */
    public List<BearerTokenSendingMethod> bearerTokenSendingMethods() {
        return this.bearerTokenSendingMethods;
    }

    /**
     * Set the bearerTokenSendingMethods property: Specifies the mechanism by which access token is passed to the API.
     * 
     * @param bearerTokenSendingMethods the bearerTokenSendingMethods value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties
        withBearerTokenSendingMethods(List<BearerTokenSendingMethod> bearerTokenSendingMethods) {
        this.bearerTokenSendingMethods = bearerTokenSendingMethods;
        return this;
    }

    /**
     * Get the resourceOwnerUsername property: Can be optionally specified when resource owner password grant type is
     * supported by this authorization server. Default resource owner username.
     * 
     * @return the resourceOwnerUsername value.
     */
    public String resourceOwnerUsername() {
        return this.resourceOwnerUsername;
    }

    /**
     * Set the resourceOwnerUsername property: Can be optionally specified when resource owner password grant type is
     * supported by this authorization server. Default resource owner username.
     * 
     * @param resourceOwnerUsername the resourceOwnerUsername value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties withResourceOwnerUsername(String resourceOwnerUsername) {
        this.resourceOwnerUsername = resourceOwnerUsername;
        return this;
    }

    /**
     * Get the resourceOwnerPassword property: Can be optionally specified when resource owner password grant type is
     * supported by this authorization server. Default resource owner password.
     * 
     * @return the resourceOwnerPassword value.
     */
    public String resourceOwnerPassword() {
        return this.resourceOwnerPassword;
    }

    /**
     * Set the resourceOwnerPassword property: Can be optionally specified when resource owner password grant type is
     * supported by this authorization server. Default resource owner password.
     * 
     * @param resourceOwnerPassword the resourceOwnerPassword value to set.
     * @return the AuthorizationServerContractBaseProperties object itself.
     */
    public AuthorizationServerContractBaseProperties withResourceOwnerPassword(String resourceOwnerPassword) {
        this.resourceOwnerPassword = resourceOwnerPassword;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (tokenBodyParameters() != null) {
            tokenBodyParameters().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeArrayField("authorizationMethods", this.authorizationMethods,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("clientAuthenticationMethod", this.clientAuthenticationMethod,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeArrayField("tokenBodyParameters", this.tokenBodyParameters,
            (writer, element) -> writer.writeJson(element));
        jsonWriter.writeStringField("tokenEndpoint", this.tokenEndpoint);
        jsonWriter.writeBooleanField("supportState", this.supportState);
        jsonWriter.writeStringField("defaultScope", this.defaultScope);
        jsonWriter.writeArrayField("bearerTokenSendingMethods", this.bearerTokenSendingMethods,
            (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeStringField("resourceOwnerUsername", this.resourceOwnerUsername);
        jsonWriter.writeStringField("resourceOwnerPassword", this.resourceOwnerPassword);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of AuthorizationServerContractBaseProperties from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of AuthorizationServerContractBaseProperties if the JsonReader was pointing to an instance of
     * it, or null if it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the AuthorizationServerContractBaseProperties.
     */
    public static AuthorizationServerContractBaseProperties fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            AuthorizationServerContractBaseProperties deserializedAuthorizationServerContractBaseProperties
                = new AuthorizationServerContractBaseProperties();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("description".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.description = reader.getString();
                } else if ("authorizationMethods".equals(fieldName)) {
                    List<AuthorizationMethod> authorizationMethods
                        = reader.readArray(reader1 -> AuthorizationMethod.fromString(reader1.getString()));
                    deserializedAuthorizationServerContractBaseProperties.authorizationMethods = authorizationMethods;
                } else if ("clientAuthenticationMethod".equals(fieldName)) {
                    List<ClientAuthenticationMethod> clientAuthenticationMethod
                        = reader.readArray(reader1 -> ClientAuthenticationMethod.fromString(reader1.getString()));
                    deserializedAuthorizationServerContractBaseProperties.clientAuthenticationMethod
                        = clientAuthenticationMethod;
                } else if ("tokenBodyParameters".equals(fieldName)) {
                    List<TokenBodyParameterContract> tokenBodyParameters
                        = reader.readArray(reader1 -> TokenBodyParameterContract.fromJson(reader1));
                    deserializedAuthorizationServerContractBaseProperties.tokenBodyParameters = tokenBodyParameters;
                } else if ("tokenEndpoint".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.tokenEndpoint = reader.getString();
                } else if ("supportState".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.supportState
                        = reader.getNullable(JsonReader::getBoolean);
                } else if ("defaultScope".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.defaultScope = reader.getString();
                } else if ("bearerTokenSendingMethods".equals(fieldName)) {
                    List<BearerTokenSendingMethod> bearerTokenSendingMethods
                        = reader.readArray(reader1 -> BearerTokenSendingMethod.fromString(reader1.getString()));
                    deserializedAuthorizationServerContractBaseProperties.bearerTokenSendingMethods
                        = bearerTokenSendingMethods;
                } else if ("resourceOwnerUsername".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.resourceOwnerUsername = reader.getString();
                } else if ("resourceOwnerPassword".equals(fieldName)) {
                    deserializedAuthorizationServerContractBaseProperties.resourceOwnerPassword = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedAuthorizationServerContractBaseProperties;
        });
    }
}
