// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.util.ExpandableStringEnum;
import java.util.Collection;

/**
 * Authorization type options.
 */
public final class AuthorizationType extends ExpandableStringEnum<AuthorizationType> {
    /**
     * Static value OAuth2 for AuthorizationType.
     */
    public static final AuthorizationType OAUTH2 = fromString("OAuth2");

    /**
     * Creates a new instance of AuthorizationType value.
     * 
     * @deprecated Use the {@link #fromString(String)} factory method.
     */
    @Deprecated
    public AuthorizationType() {
    }

    /**
     * Creates or finds a AuthorizationType from its string representation.
     * 
     * @param name a name to look for.
     * @return the corresponding AuthorizationType.
     */
    public static AuthorizationType fromString(String name) {
        return fromString(name, AuthorizationType.class);
    }

    /**
     * Gets known AuthorizationType values.
     * 
     * @return known AuthorizationType values.
     */
    public static Collection<AuthorizationType> values() {
        return values(AuthorizationType.class);
    }
}
