// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Authorization header information.
 */
@Fluent
public final class BackendAuthorizationHeaderCredentials
    implements JsonSerializable<BackendAuthorizationHeaderCredentials> {
    /*
     * Authentication Scheme name.
     */
    private String scheme;

    /*
     * Authentication Parameter value.
     */
    private String parameter;

    /**
     * Creates an instance of BackendAuthorizationHeaderCredentials class.
     */
    public BackendAuthorizationHeaderCredentials() {
    }

    /**
     * Get the scheme property: Authentication Scheme name.
     * 
     * @return the scheme value.
     */
    public String scheme() {
        return this.scheme;
    }

    /**
     * Set the scheme property: Authentication Scheme name.
     * 
     * @param scheme the scheme value to set.
     * @return the BackendAuthorizationHeaderCredentials object itself.
     */
    public BackendAuthorizationHeaderCredentials withScheme(String scheme) {
        this.scheme = scheme;
        return this;
    }

    /**
     * Get the parameter property: Authentication Parameter value.
     * 
     * @return the parameter value.
     */
    public String parameter() {
        return this.parameter;
    }

    /**
     * Set the parameter property: Authentication Parameter value.
     * 
     * @param parameter the parameter value to set.
     * @return the BackendAuthorizationHeaderCredentials object itself.
     */
    public BackendAuthorizationHeaderCredentials withParameter(String parameter) {
        this.parameter = parameter;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (scheme() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property scheme in model BackendAuthorizationHeaderCredentials"));
        }
        if (parameter() == null) {
            throw LOGGER.atError()
                .log(new IllegalArgumentException(
                    "Missing required property parameter in model BackendAuthorizationHeaderCredentials"));
        }
    }

    private static final ClientLogger LOGGER = new ClientLogger(BackendAuthorizationHeaderCredentials.class);

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("scheme", this.scheme);
        jsonWriter.writeStringField("parameter", this.parameter);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendAuthorizationHeaderCredentials from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendAuthorizationHeaderCredentials if the JsonReader was pointing to an instance of it,
     * or null if it was pointing to JSON null.
     * @throws IllegalStateException If the deserialized JSON object was missing any required properties.
     * @throws IOException If an error occurs while reading the BackendAuthorizationHeaderCredentials.
     */
    public static BackendAuthorizationHeaderCredentials fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendAuthorizationHeaderCredentials deserializedBackendAuthorizationHeaderCredentials
                = new BackendAuthorizationHeaderCredentials();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("scheme".equals(fieldName)) {
                    deserializedBackendAuthorizationHeaderCredentials.scheme = reader.getString();
                } else if ("parameter".equals(fieldName)) {
                    deserializedBackendAuthorizationHeaderCredentials.parameter = reader.getString();
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendAuthorizationHeaderCredentials;
        });
    }
}
