// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Backend entity base Parameter set.
 */
@Fluent
public class BackendBaseParameters implements JsonSerializable<BackendBaseParameters> {
    /*
     * Backend Title.
     */
    private String title;

    /*
     * Backend Description.
     */
    private String description;

    /*
     * Management Uri of the Resource in External System. This URL can be the Arm Resource Id of Logic Apps, Function
     * Apps or API Apps.
     */
    private String resourceId;

    /*
     * Backend Properties contract
     */
    private BackendProperties properties;

    /*
     * Backend Credentials Contract Properties
     */
    private BackendCredentialsContract credentials;

    /*
     * Backend gateway Contract Properties
     */
    private BackendProxyContract proxy;

    /*
     * Backend TLS Properties
     */
    private BackendTlsProperties tls;

    /*
     * Backend Circuit Breaker Configuration
     */
    private BackendCircuitBreaker circuitBreaker;

    /*
     * The pool property.
     */
    private BackendBaseParametersPool pool;

    /*
     * Type of the backend. A backend can be either Single or Pool.
     */
    private BackendType type;

    /**
     * Creates an instance of BackendBaseParameters class.
     */
    public BackendBaseParameters() {
    }

    /**
     * Get the title property: Backend Title.
     * 
     * @return the title value.
     */
    public String title() {
        return this.title;
    }

    /**
     * Set the title property: Backend Title.
     * 
     * @param title the title value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withTitle(String title) {
        this.title = title;
        return this;
    }

    /**
     * Get the description property: Backend Description.
     * 
     * @return the description value.
     */
    public String description() {
        return this.description;
    }

    /**
     * Set the description property: Backend Description.
     * 
     * @param description the description value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withDescription(String description) {
        this.description = description;
        return this;
    }

    /**
     * Get the resourceId property: Management Uri of the Resource in External System. This URL can be the Arm Resource
     * Id of Logic Apps, Function Apps or API Apps.
     * 
     * @return the resourceId value.
     */
    public String resourceId() {
        return this.resourceId;
    }

    /**
     * Set the resourceId property: Management Uri of the Resource in External System. This URL can be the Arm Resource
     * Id of Logic Apps, Function Apps or API Apps.
     * 
     * @param resourceId the resourceId value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withResourceId(String resourceId) {
        this.resourceId = resourceId;
        return this;
    }

    /**
     * Get the properties property: Backend Properties contract.
     * 
     * @return the properties value.
     */
    public BackendProperties properties() {
        return this.properties;
    }

    /**
     * Set the properties property: Backend Properties contract.
     * 
     * @param properties the properties value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withProperties(BackendProperties properties) {
        this.properties = properties;
        return this;
    }

    /**
     * Get the credentials property: Backend Credentials Contract Properties.
     * 
     * @return the credentials value.
     */
    public BackendCredentialsContract credentials() {
        return this.credentials;
    }

    /**
     * Set the credentials property: Backend Credentials Contract Properties.
     * 
     * @param credentials the credentials value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withCredentials(BackendCredentialsContract credentials) {
        this.credentials = credentials;
        return this;
    }

    /**
     * Get the proxy property: Backend gateway Contract Properties.
     * 
     * @return the proxy value.
     */
    public BackendProxyContract proxy() {
        return this.proxy;
    }

    /**
     * Set the proxy property: Backend gateway Contract Properties.
     * 
     * @param proxy the proxy value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withProxy(BackendProxyContract proxy) {
        this.proxy = proxy;
        return this;
    }

    /**
     * Get the tls property: Backend TLS Properties.
     * 
     * @return the tls value.
     */
    public BackendTlsProperties tls() {
        return this.tls;
    }

    /**
     * Set the tls property: Backend TLS Properties.
     * 
     * @param tls the tls value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withTls(BackendTlsProperties tls) {
        this.tls = tls;
        return this;
    }

    /**
     * Get the circuitBreaker property: Backend Circuit Breaker Configuration.
     * 
     * @return the circuitBreaker value.
     */
    public BackendCircuitBreaker circuitBreaker() {
        return this.circuitBreaker;
    }

    /**
     * Set the circuitBreaker property: Backend Circuit Breaker Configuration.
     * 
     * @param circuitBreaker the circuitBreaker value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withCircuitBreaker(BackendCircuitBreaker circuitBreaker) {
        this.circuitBreaker = circuitBreaker;
        return this;
    }

    /**
     * Get the pool property: The pool property.
     * 
     * @return the pool value.
     */
    public BackendBaseParametersPool pool() {
        return this.pool;
    }

    /**
     * Set the pool property: The pool property.
     * 
     * @param pool the pool value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withPool(BackendBaseParametersPool pool) {
        this.pool = pool;
        return this;
    }

    /**
     * Get the type property: Type of the backend. A backend can be either Single or Pool.
     * 
     * @return the type value.
     */
    public BackendType type() {
        return this.type;
    }

    /**
     * Set the type property: Type of the backend. A backend can be either Single or Pool.
     * 
     * @param type the type value to set.
     * @return the BackendBaseParameters object itself.
     */
    public BackendBaseParameters withType(BackendType type) {
        this.type = type;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (properties() != null) {
            properties().validate();
        }
        if (credentials() != null) {
            credentials().validate();
        }
        if (proxy() != null) {
            proxy().validate();
        }
        if (tls() != null) {
            tls().validate();
        }
        if (circuitBreaker() != null) {
            circuitBreaker().validate();
        }
        if (pool() != null) {
            pool().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("title", this.title);
        jsonWriter.writeStringField("description", this.description);
        jsonWriter.writeStringField("resourceId", this.resourceId);
        jsonWriter.writeJsonField("properties", this.properties);
        jsonWriter.writeJsonField("credentials", this.credentials);
        jsonWriter.writeJsonField("proxy", this.proxy);
        jsonWriter.writeJsonField("tls", this.tls);
        jsonWriter.writeJsonField("circuitBreaker", this.circuitBreaker);
        jsonWriter.writeJsonField("pool", this.pool);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendBaseParameters from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendBaseParameters if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackendBaseParameters.
     */
    public static BackendBaseParameters fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendBaseParameters deserializedBackendBaseParameters = new BackendBaseParameters();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("title".equals(fieldName)) {
                    deserializedBackendBaseParameters.title = reader.getString();
                } else if ("description".equals(fieldName)) {
                    deserializedBackendBaseParameters.description = reader.getString();
                } else if ("resourceId".equals(fieldName)) {
                    deserializedBackendBaseParameters.resourceId = reader.getString();
                } else if ("properties".equals(fieldName)) {
                    deserializedBackendBaseParameters.properties = BackendProperties.fromJson(reader);
                } else if ("credentials".equals(fieldName)) {
                    deserializedBackendBaseParameters.credentials = BackendCredentialsContract.fromJson(reader);
                } else if ("proxy".equals(fieldName)) {
                    deserializedBackendBaseParameters.proxy = BackendProxyContract.fromJson(reader);
                } else if ("tls".equals(fieldName)) {
                    deserializedBackendBaseParameters.tls = BackendTlsProperties.fromJson(reader);
                } else if ("circuitBreaker".equals(fieldName)) {
                    deserializedBackendBaseParameters.circuitBreaker = BackendCircuitBreaker.fromJson(reader);
                } else if ("pool".equals(fieldName)) {
                    deserializedBackendBaseParameters.pool = BackendBaseParametersPool.fromJson(reader);
                } else if ("type".equals(fieldName)) {
                    deserializedBackendBaseParameters.type = BackendType.fromString(reader.getString());
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendBaseParameters;
        });
    }
}
