// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The BackendBaseParametersPool model.
 */
@Fluent
public final class BackendBaseParametersPool extends BackendPool {
    /**
     * Creates an instance of BackendBaseParametersPool class.
     */
    public BackendBaseParametersPool() {
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public BackendBaseParametersPool withServices(List<BackendPoolItem> services) {
        super.withServices(services);
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    @Override
    public void validate() {
        if (services() != null) {
            services().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("services", services(), (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendBaseParametersPool from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendBaseParametersPool if the JsonReader was pointing to an instance of it, or null if
     * it was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackendBaseParametersPool.
     */
    public static BackendBaseParametersPool fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendBaseParametersPool deserializedBackendBaseParametersPool = new BackendBaseParametersPool();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("services".equals(fieldName)) {
                    List<BackendPoolItem> services = reader.readArray(reader1 -> BackendPoolItem.fromJson(reader1));
                    deserializedBackendBaseParametersPool.withServices(services);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendBaseParametersPool;
        });
    }
}
