// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;

/**
 * The configuration of the backend circuit breaker.
 */
@Fluent
public final class BackendCircuitBreaker implements JsonSerializable<BackendCircuitBreaker> {
    /*
     * The rules for tripping the backend.
     */
    private List<CircuitBreakerRule> rules;

    /**
     * Creates an instance of BackendCircuitBreaker class.
     */
    public BackendCircuitBreaker() {
    }

    /**
     * Get the rules property: The rules for tripping the backend.
     * 
     * @return the rules value.
     */
    public List<CircuitBreakerRule> rules() {
        return this.rules;
    }

    /**
     * Set the rules property: The rules for tripping the backend.
     * 
     * @param rules the rules value to set.
     * @return the BackendCircuitBreaker object itself.
     */
    public BackendCircuitBreaker withRules(List<CircuitBreakerRule> rules) {
        this.rules = rules;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (rules() != null) {
            rules().forEach(e -> e.validate());
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("rules", this.rules, (writer, element) -> writer.writeJson(element));
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendCircuitBreaker from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendCircuitBreaker if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackendCircuitBreaker.
     */
    public static BackendCircuitBreaker fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendCircuitBreaker deserializedBackendCircuitBreaker = new BackendCircuitBreaker();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("rules".equals(fieldName)) {
                    List<CircuitBreakerRule> rules = reader.readArray(reader1 -> CircuitBreakerRule.fromJson(reader1));
                    deserializedBackendCircuitBreaker.rules = rules;
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendCircuitBreaker;
        });
    }
}
