// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License.
// Code generated by Microsoft (R) AutoRest Code Generator.

package com.azure.resourcemanager.apimanagement.models;

import com.azure.core.annotation.Fluent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

/**
 * Information regarding how the gateway should integrate with backend systems.
 */
@Fluent
public final class BackendConfiguration implements JsonSerializable<BackendConfiguration> {
    /*
     * The default hostname of the data-plane gateway to which requests can be sent.
     */
    private BackendSubnetConfiguration subnet;

    /**
     * Creates an instance of BackendConfiguration class.
     */
    public BackendConfiguration() {
    }

    /**
     * Get the subnet property: The default hostname of the data-plane gateway to which requests can be sent.
     * 
     * @return the subnet value.
     */
    public BackendSubnetConfiguration subnet() {
        return this.subnet;
    }

    /**
     * Set the subnet property: The default hostname of the data-plane gateway to which requests can be sent.
     * 
     * @param subnet the subnet value to set.
     * @return the BackendConfiguration object itself.
     */
    public BackendConfiguration withSubnet(BackendSubnetConfiguration subnet) {
        this.subnet = subnet;
        return this;
    }

    /**
     * Validates the instance.
     * 
     * @throws IllegalArgumentException thrown if the instance is not valid.
     */
    public void validate() {
        if (subnet() != null) {
            subnet().validate();
        }
    }

    /**
     * {@inheritDoc}
     */
    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("subnet", this.subnet);
        return jsonWriter.writeEndObject();
    }

    /**
     * Reads an instance of BackendConfiguration from the JsonReader.
     * 
     * @param jsonReader The JsonReader being read.
     * @return An instance of BackendConfiguration if the JsonReader was pointing to an instance of it, or null if it
     * was pointing to JSON null.
     * @throws IOException If an error occurs while reading the BackendConfiguration.
     */
    public static BackendConfiguration fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            BackendConfiguration deserializedBackendConfiguration = new BackendConfiguration();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();

                if ("subnet".equals(fieldName)) {
                    deserializedBackendConfiguration.subnet = BackendSubnetConfiguration.fromJson(reader);
                } else {
                    reader.skipChildren();
                }
            }

            return deserializedBackendConfiguration;
        });
    }
}
